/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.dual;

import com.facebook.presto.connector.InternalConnector;
import com.facebook.presto.connector.dual.DualDataStreamProvider;
import com.facebook.presto.connector.dual.DualHandleResolver;
import com.facebook.presto.connector.dual.DualMetadata;
import com.facebook.presto.connector.dual.DualSplitManager;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorOutputHandleResolver;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.split.ConnectorDataStreamProvider;
import com.google.common.base.Preconditions;
import javax.inject.Inject;

public class DualConnector
implements InternalConnector {
    private final NodeManager nodeManager;

    @Inject
    public DualConnector(NodeManager nodeManager) {
        this.nodeManager = (NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new DualHandleResolver();
    }

    public ConnectorMetadata getMetadata() {
        return new DualMetadata();
    }

    public ConnectorSplitManager getSplitManager() {
        return new DualSplitManager(this.nodeManager);
    }

    @Override
    public ConnectorDataStreamProvider getDataStreamProvider() {
        return new DualDataStreamProvider();
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        throw new UnsupportedOperationException();
    }

    public ConnectorRecordSinkProvider getRecordSinkProvider() {
        throw new UnsupportedOperationException();
    }

    public ConnectorOutputHandleResolver getOutputHandleResolver() {
        throw new UnsupportedOperationException();
    }
}

