/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.informationSchema;

import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class InformationSchemaTableHandle
implements TableHandle {
    private final String catalogName;
    private final String schemaName;
    private final String tableName;

    @JsonCreator
    public InformationSchemaTableHandle(@JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName) {
        this.catalogName = (String)Preconditions.checkNotNull((Object)catalogName, (Object)"catalogName is null");
        this.schemaName = (String)Preconditions.checkNotNull((Object)schemaName, (Object)"schemaName is null");
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
    }

    @JsonProperty
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public String toString() {
        return "information_schema:" + this.catalogName + ":" + this.schemaName + ":" + this.tableName;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.catalogName, this.schemaName, this.tableName});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InformationSchemaTableHandle other = (InformationSchemaTableHandle)obj;
        return Objects.equal((Object)this.catalogName, (Object)other.catalogName) && Objects.equal((Object)this.schemaName, (Object)other.schemaName) && Objects.equal((Object)this.tableName, (Object)other.tableName);
    }
}

