/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.jmx;

import com.facebook.presto.connector.InternalConnector;
import com.facebook.presto.connector.jmx.JmxConnectorId;
import com.facebook.presto.connector.jmx.JmxDataStreamProvider;
import com.facebook.presto.connector.jmx.JmxHandleResolver;
import com.facebook.presto.connector.jmx.JmxMetadata;
import com.facebook.presto.connector.jmx.JmxSplitManager;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorOutputHandleResolver;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.split.ConnectorDataStreamProvider;
import com.google.common.base.Preconditions;
import io.airlift.node.NodeInfo;
import java.util.Map;
import javax.inject.Inject;
import javax.management.MBeanServer;

public class JmxConnectorFactory
implements ConnectorFactory {
    private final MBeanServer mbeanServer;
    private final NodeManager nodeManager;
    private final NodeInfo nodeInfo;

    @Inject
    public JmxConnectorFactory(MBeanServer mbeanServer, NodeManager nodeManager, NodeInfo nodeInfo) {
        this.mbeanServer = (MBeanServer)Preconditions.checkNotNull((Object)mbeanServer, (Object)"mbeanServer is null");
        this.nodeManager = (NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
        this.nodeInfo = (NodeInfo)Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
    }

    public String getName() {
        return "jmx";
    }

    public Connector create(final String connectorId, Map<String, String> properties) {
        return new InternalConnector(){

            public ConnectorHandleResolver getHandleResolver() {
                return new JmxHandleResolver();
            }

            public ConnectorMetadata getMetadata() {
                return new JmxMetadata(new JmxConnectorId(connectorId), JmxConnectorFactory.this.mbeanServer);
            }

            public ConnectorSplitManager getSplitManager() {
                return new JmxSplitManager(new JmxConnectorId(connectorId), JmxConnectorFactory.this.nodeManager);
            }

            @Override
            public ConnectorDataStreamProvider getDataStreamProvider() {
                return new JmxDataStreamProvider(new JmxConnectorId(connectorId), JmxConnectorFactory.this.mbeanServer, JmxConnectorFactory.this.nodeInfo);
            }

            public ConnectorRecordSetProvider getRecordSetProvider() {
                throw new UnsupportedOperationException();
            }

            public ConnectorRecordSinkProvider getRecordSinkProvider() {
                throw new UnsupportedOperationException();
            }

            public ConnectorOutputHandleResolver getOutputHandleResolver() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

