/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.jmx;

import com.facebook.presto.connector.jmx.JmxColumnHandle;
import com.facebook.presto.connector.jmx.JmxConnectorId;
import com.facebook.presto.connector.jmx.JmxSplit;
import com.facebook.presto.connector.jmx.JmxTableHandle;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.RecordProjectOperator;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.Split;
import com.facebook.presto.split.ConnectorDataStreamProvider;
import com.facebook.presto.util.IterableTransformer;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.node.NodeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class JmxDataStreamProvider
implements ConnectorDataStreamProvider {
    private final String connectorId;
    private final MBeanServer mbeanServer;
    private final String nodeId;

    @Inject
    public JmxDataStreamProvider(JmxConnectorId jmxConnectorId, MBeanServer mbeanServer, NodeInfo nodeInfo) {
        this.connectorId = ((JmxConnectorId)Preconditions.checkNotNull((Object)jmxConnectorId, (Object)"jmxConnectorId is null")).toString();
        this.mbeanServer = (MBeanServer)Preconditions.checkNotNull((Object)mbeanServer, (Object)"mbeanServer is null");
        this.nodeId = ((NodeInfo)Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null")).getNodeId();
    }

    @Override
    public boolean canHandle(Split split) {
        return split instanceof JmxSplit && ((JmxSplit)split).getTableHandle().getConnectorId().equals(this.connectorId);
    }

    @Override
    public Operator createNewDataStream(OperatorContext operatorContext, Split split, List<ColumnHandle> columns) {
        return new RecordProjectOperator(operatorContext, this.createRecordSet(split, columns));
    }

    private RecordSet createRecordSet(Split split, List<ColumnHandle> columns) {
        ImmutableList rows;
        Preconditions.checkNotNull((Object)split, (Object)"split is null");
        Preconditions.checkArgument((boolean)(split instanceof JmxSplit), (String)"Split must be of type %s, not %s", (Object[])new Object[]{JmxSplit.class.getName(), split.getClass().getName()});
        JmxTableHandle tableHandle = ((JmxSplit)split).getTableHandle();
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        Preconditions.checkArgument((!columns.isEmpty() ? 1 : 0) != 0, (Object)"must provide at least one column");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ColumnHandle column : columns) {
            Preconditions.checkArgument((boolean)(column instanceof JmxColumnHandle), (String)"column must be of type %s, not %s", (Object[])new Object[]{JmxColumnHandle.class.getName(), column.getClass().getName()});
            JmxColumnHandle jmxColumnHandle = (JmxColumnHandle)column;
            builder.put((Object)jmxColumnHandle.getColumnName(), (Object)jmxColumnHandle.getColumnType());
        }
        ImmutableMap columnTypes = builder.build();
        try {
            Map<String, Object> attributes = this.getAttributes((Set<String>)columnTypes.keySet(), tableHandle);
            ArrayList<Object> row = new ArrayList<Object>();
            for (Map.Entry entry : columnTypes.entrySet()) {
                if (((String)entry.getKey()).equals("node")) {
                    row.add(this.nodeId);
                    continue;
                }
                Object value = attributes.get(entry.getKey());
                if (value == null) {
                    row.add(null);
                    continue;
                }
                switch ((ColumnType)entry.getValue()) {
                    case BOOLEAN: {
                        if (value instanceof Boolean) {
                            row.add(value);
                            break;
                        }
                        row.add(null);
                        break;
                    }
                    case LONG: {
                        if (value instanceof Number) {
                            row.add(((Number)value).longValue());
                            break;
                        }
                        row.add(null);
                        break;
                    }
                    case DOUBLE: {
                        if (value instanceof Number) {
                            row.add(((Number)value).doubleValue());
                            break;
                        }
                        row.add(null);
                        break;
                    }
                    case STRING: {
                        row.add(value.toString());
                    }
                }
            }
            rows = ImmutableList.of(row);
        }
        catch (JMException e) {
            rows = ImmutableList.of();
        }
        return new InMemoryRecordSet((Collection)columnTypes.values(), (Collection)rows);
    }

    private Map<String, Object> getAttributes(Set<String> uniqueColumnNames, JmxTableHandle tableHandle) throws JMException {
        ObjectName objectName = new ObjectName(tableHandle.getObjectName());
        String[] columnNamesArray = uniqueColumnNames.toArray(new String[uniqueColumnNames.size()]);
        return IterableTransformer.on(this.mbeanServer.getAttributes(objectName, columnNamesArray).asList()).uniqueIndex(this.attributeNameGetter()).transformValues(this.attributeValueGetter()).map();
    }

    private Function<Attribute, String> attributeNameGetter() {
        return new Function<Attribute, String>(){

            public String apply(Attribute attribute) {
                return attribute.getName();
            }
        };
    }

    private Function<Attribute, Object> attributeValueGetter() {
        return new Function<Attribute, Object>(){

            public Object apply(Attribute attribute) {
                return attribute.getValue();
            }
        };
    }
}

