/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;

public class CatalogSystemTable
implements SystemTable {
    public static final SchemaTableName CATALOG_TABLE_NAME = new SchemaTableName("sys", "catalog");
    public static final ConnectorTableMetadata CATALOG_TABLE = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(CATALOG_TABLE_NAME).column("catalog_name", ColumnType.STRING).column("connector_id", ColumnType.STRING).build();
    private final Metadata metadata;

    @Inject
    public CatalogSystemTable(Metadata metadata) {
        this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata);
    }

    public boolean isDistributed() {
        return false;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return CATALOG_TABLE;
    }

    public List<ColumnType> getColumnTypes() {
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)CATALOG_TABLE.getColumns(), MetadataUtil.columnTypeGetter()));
    }

    public RecordCursor cursor() {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)CATALOG_TABLE);
        for (Map.Entry<String, String> entry : this.metadata.getCatalogNames().entrySet()) {
            table.addRow(new Object[]{entry.getKey(), entry.getValue()});
        }
        return table.build().cursor();
    }
}

