/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.system.SystemColumnHandle;
import com.facebook.presto.connector.system.SystemSplit;
import com.facebook.presto.connector.system.SystemTableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.Partition;
import com.facebook.presto.spi.PartitionResult;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SplitSource;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class SystemSplitManager
implements ConnectorSplitManager {
    private final NodeManager nodeManager;
    private final ConcurrentMap<SchemaTableName, SystemTable> tables = new ConcurrentHashMap<SchemaTableName, SystemTable>();

    @Inject
    public SystemSplitManager(NodeManager nodeManager) {
        this.nodeManager = (NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
    }

    public void addTable(SystemTable systemTable) {
        Preconditions.checkNotNull((Object)systemTable, (Object)"systemTable is null");
        SchemaTableName tableName = systemTable.getTableMetadata().getTable();
        Preconditions.checkArgument((this.tables.putIfAbsent(tableName, systemTable) == null ? 1 : 0) != 0, (String)"Table %s is already registered", (Object[])new Object[]{tableName});
    }

    public String getConnectorId() {
        return null;
    }

    public boolean canHandle(TableHandle handle) {
        return handle instanceof SystemTableHandle;
    }

    public PartitionResult getPartitions(TableHandle table, TupleDomain tupleDomain) {
        Preconditions.checkNotNull((Object)table, (Object)"table is null");
        Preconditions.checkNotNull((Object)tupleDomain, (Object)"tupleDomain is null");
        Preconditions.checkArgument((boolean)(table instanceof SystemTableHandle), (Object)"TableHandle must be an SystemTableHandle");
        SystemTableHandle systemTableHandle = (SystemTableHandle)table;
        Map bindings = tupleDomain.extractFixedValues();
        TupleDomain unusedTupleDomain = TupleDomain.none();
        if (!tupleDomain.isNone()) {
            unusedTupleDomain = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)tupleDomain.getDomains(), (Predicate)Predicates.not((Predicate)Predicates.in(bindings.keySet()))));
        }
        ImmutableList partitions = ImmutableList.of((Object)new SystemPartition(systemTableHandle, bindings));
        return new PartitionResult((List)partitions, unusedTupleDomain);
    }

    public SplitSource getPartitionSplits(TableHandle table, List<Partition> partitions) {
        Preconditions.checkNotNull(partitions, (Object)"partitions is null");
        if (partitions.isEmpty()) {
            return new FixedSplitSource(null, (Iterable)ImmutableList.of());
        }
        Partition partition = (Partition)Iterables.getOnlyElement(partitions);
        Preconditions.checkArgument((boolean)(partition instanceof SystemPartition), (Object)"Partition must be a system partition");
        SystemPartition systemPartition = (SystemPartition)partition;
        SystemTable systemTable = (SystemTable)this.tables.get(systemPartition.getTableHandle().getSchemaTableName());
        Preconditions.checkArgument((systemTable != null ? 1 : 0) != 0, (String)"Table %s does not exist", (Object[])new Object[]{systemPartition.getTableHandle().getTableName()});
        ImmutableMap.Builder filters = ImmutableMap.builder();
        for (Map.Entry<ColumnHandle, Comparable<?>> entry : systemPartition.getFilters().entrySet()) {
            SystemColumnHandle systemColumnHandle = (SystemColumnHandle)entry.getKey();
            filters.put((Object)systemColumnHandle.getColumnName(), entry.getValue());
        }
        if (systemTable.isDistributed()) {
            ImmutableList.Builder splits = ImmutableList.builder();
            for (Node node : this.nodeManager.getActiveNodes()) {
                splits.add((Object)new SystemSplit(systemPartition.tableHandle, (Map<String, Object>)filters.build(), node.getHostAndPort()));
            }
            return new FixedSplitSource(null, (Iterable)splits.build());
        }
        HostAddress address = this.nodeManager.getCurrentNode().getHostAndPort();
        SystemSplit split = new SystemSplit(systemPartition.tableHandle, (Map<String, Object>)filters.build(), address);
        return new FixedSplitSource(null, (Iterable)ImmutableList.of((Object)split));
    }

    public static class SystemPartition
    implements Partition {
        private final SystemTableHandle tableHandle;
        private final Map<ColumnHandle, Comparable<?>> filters;

        public SystemPartition(SystemTableHandle tableHandle, Map<ColumnHandle, Comparable<?>> filters) {
            this.tableHandle = (SystemTableHandle)Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
            this.filters = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(filters, (Object)"filters is null")));
        }

        public SystemTableHandle getTableHandle() {
            return this.tableHandle;
        }

        public String getPartitionId() {
            return this.tableHandle.getSchemaTableName().toString();
        }

        public TupleDomain getTupleDomain() {
            return TupleDomain.withFixedValues(this.filters);
        }

        public Map<ColumnHandle, Comparable<?>> getFilters() {
            return this.filters;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("tableHandle", (Object)this.tableHandle).add("filters", this.filters).toString();
        }
    }
}

