/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManager;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.node.NodeInfo;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.joda.time.DateTime;

public class TaskSystemTable
implements SystemTable {
    public static final SchemaTableName TASK_TABLE_NAME = new SchemaTableName("sys", "task");
    public static final ConnectorTableMetadata TASK_TABLE = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TASK_TABLE_NAME).column("node_id", ColumnType.STRING).column("task_id", ColumnType.STRING).column("stage_id", ColumnType.STRING).column("query_id", ColumnType.STRING).column("state", ColumnType.STRING).column("splits", ColumnType.LONG).column("queued_splits", ColumnType.LONG).column("running_splits", ColumnType.LONG).column("completed_splits", ColumnType.LONG).column("split_scheduled_time_ms", ColumnType.LONG).column("split_cpu_time_ms", ColumnType.LONG).column("split_user_time_ms", ColumnType.LONG).column("split_blocked_time_ms", ColumnType.LONG).column("raw_input_bytes", ColumnType.LONG).column("raw_input_rows", ColumnType.LONG).column("processed_input_bytes", ColumnType.LONG).column("processed_input_rows", ColumnType.LONG).column("output_bytes", ColumnType.LONG).column("output_rows", ColumnType.LONG).column("created", ColumnType.LONG).column("start", ColumnType.LONG).column("last_heartbeat", ColumnType.LONG).column("end", ColumnType.LONG).build();
    private final TaskManager taskManager;
    private final String nodeId;

    @Inject
    public TaskSystemTable(TaskManager taskManager, NodeInfo nodeInfo) {
        this.taskManager = taskManager;
        this.nodeId = nodeInfo.getNodeId();
    }

    public boolean isDistributed() {
        return true;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return TASK_TABLE;
    }

    public List<ColumnType> getColumnTypes() {
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)TASK_TABLE.getColumns(), MetadataUtil.columnTypeGetter()));
    }

    public RecordCursor cursor() {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)TASK_TABLE);
        for (TaskInfo taskInfo : this.taskManager.getAllTaskInfo(false)) {
            TaskStats stats = taskInfo.getStats();
            table.addRow(new Object[]{this.nodeId, taskInfo.getTaskId().toString(), taskInfo.getTaskId().getStageId().toString(), taskInfo.getTaskId().getQueryId().toString(), taskInfo.getState().toString(), (long)stats.getTotalDrivers(), (long)stats.getQueuedDrivers(), (long)stats.getRunningDrivers(), (long)stats.getCompletedDrivers(), this.toMillis(stats.getTotalScheduledTime()), this.toMillis(stats.getTotalCpuTime()), this.toMillis(stats.getTotalUserTime()), this.toMillis(stats.getTotalBlockedTime()), this.toBytes(stats.getRawInputDataSize()), stats.getRawInputPositions(), this.toBytes(stats.getProcessedInputDataSize()), stats.getProcessedInputPositions(), this.toBytes(stats.getOutputDataSize()), stats.getOutputPositions(), this.toTimeStamp(stats.getCreateTime()), this.toTimeStamp(stats.getFirstStartTime()), this.toTimeStamp(taskInfo.getLastHeartbeat()), this.toTimeStamp(stats.getEndTime())});
        }
        return table.build().cursor();
    }

    private Long toMillis(Duration duration) {
        if (duration == null) {
            return null;
        }
        return duration.toMillis();
    }

    private Long toBytes(DataSize dataSize) {
        if (dataSize == null) {
            return null;
        }
        return dataSize.toBytes();
    }

    private Long toTimeStamp(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return TimeUnit.MILLISECONDS.toSeconds(dateTime.getMillis());
    }
}

