/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.event.query;

import com.facebook.presto.client.FailureInfo;
import com.facebook.presto.event.query.QueryCompletionEvent;
import com.facebook.presto.event.query.QueryCreatedEvent;
import com.facebook.presto.event.query.SplitCompletionEvent;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.TaskStats;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import io.airlift.event.client.EventClient;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import io.airlift.units.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class QueryMonitor {
    private static final Logger log = Logger.get(QueryMonitor.class);
    private final ObjectMapper objectMapper;
    private final EventClient eventClient;
    private final String environment;

    @Inject
    public QueryMonitor(ObjectMapper objectMapper, EventClient eventClient, NodeInfo nodeInfo) {
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper, (Object)"objectMapper is null");
        this.eventClient = (EventClient)Preconditions.checkNotNull((Object)eventClient, (Object)"eventClient is null");
        this.environment = ((NodeInfo)Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null")).getEnvironment();
    }

    public void createdEvent(QueryInfo queryInfo) {
        this.eventClient.post((Object[])new QueryCreatedEvent[]{new QueryCreatedEvent(queryInfo.getQueryId(), queryInfo.getSession().getUser(), queryInfo.getSession().getSource(), this.environment, queryInfo.getSession().getCatalog(), queryInfo.getSession().getSchema(), queryInfo.getSession().getRemoteUserAddress(), queryInfo.getSession().getUserAgent(), queryInfo.getSelf(), queryInfo.getQuery(), queryInfo.getQueryStats().getCreateTime())});
    }

    public void completionEvent(QueryInfo queryInfo) {
        try {
            QueryStats queryStats = queryInfo.getQueryStats();
            FailureInfo failureInfo = queryInfo.getFailureInfo();
            String failureType = failureInfo == null ? null : failureInfo.getType();
            String failureMessage = failureInfo == null ? null : failureInfo.getMessage();
            this.eventClient.post((Object[])new QueryCompletionEvent[]{new QueryCompletionEvent(queryInfo.getQueryId(), queryInfo.getSession().getUser(), queryInfo.getSession().getSource(), this.environment, queryInfo.getSession().getCatalog(), queryInfo.getSession().getSchema(), queryInfo.getSession().getRemoteUserAddress(), queryInfo.getSession().getUserAgent(), queryInfo.getState(), queryInfo.getSelf(), queryInfo.getFieldNames(), queryInfo.getQuery(), queryStats.getCreateTime(), queryStats.getExecutionStartTime(), queryStats.getEndTime(), queryStats.getQueuedTime(), queryStats.getAnalysisTime(), queryStats.getDistributedPlanningTime(), queryStats.getTotalScheduledTime(), queryStats.getTotalCpuTime(), queryStats.getRawInputDataSize(), queryStats.getRawInputPositions(), queryStats.getTotalDrivers(), queryInfo.getErrorCode(), failureType, failureMessage, this.objectMapper.writeValueAsString((Object)queryInfo.getOutputStage()), this.objectMapper.writeValueAsString((Object)queryInfo.getFailureInfo()), this.objectMapper.writeValueAsString(queryInfo.getInputs()))});
            this.logQueryTimeline(queryInfo);
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void logQueryTimeline(QueryInfo queryInfo) {
        try {
            QueryStats queryStats = queryInfo.getQueryStats();
            DateTime queryStartTime = queryStats.getCreateTime();
            DateTime queryEndTime = queryStats.getEndTime();
            if (queryStartTime == null || queryEndTime == null) {
                return;
            }
            Duration planning = queryStats.getTotalPlanningTime();
            if (planning == null) {
                planning = new Duration(0.0, TimeUnit.MILLISECONDS);
            }
            List<StageInfo> stages = StageInfo.getAllStages(queryInfo.getOutputStage());
            long firstTaskStartTime = queryEndTime.getMillis();
            long lastTaskStartTime = queryStartTime.getMillis() + planning.toMillis();
            long lastTaskEndTime = queryStartTime.getMillis() + planning.toMillis();
            for (StageInfo stage : stages) {
                if (!stage.getSubStages().isEmpty()) continue;
                for (TaskInfo taskInfo : stage.getTasks()) {
                    DateTime endTime;
                    DateTime lastStartTime;
                    TaskStats taskStats = taskInfo.getStats();
                    DateTime firstStartTime = taskStats.getFirstStartTime();
                    if (firstStartTime != null) {
                        firstTaskStartTime = Math.min(firstStartTime.getMillis(), firstTaskStartTime);
                    }
                    if ((lastStartTime = taskStats.getLastStartTime()) != null) {
                        lastTaskStartTime = Math.max(lastStartTime.getMillis(), lastTaskStartTime);
                    }
                    if ((endTime = taskStats.getEndTime()) == null) continue;
                    lastTaskEndTime = Math.max(endTime.getMillis(), lastTaskEndTime);
                }
            }
            Duration elapsed = QueryMonitor.millis(queryEndTime.getMillis() - queryStartTime.getMillis());
            Duration scheduling = QueryMonitor.millis(firstTaskStartTime - queryStartTime.getMillis() - planning.toMillis());
            Duration running = QueryMonitor.millis(lastTaskEndTime - firstTaskStartTime);
            Duration finishing = QueryMonitor.millis(queryEndTime.getMillis() - lastTaskEndTime);
            log.info("TIMELINE: Query %s :: elapsed %s :: planning %s :: scheduling %s :: running %s :: finishing %s :: begin %s :: end %s", new Object[]{queryInfo.getQueryId(), elapsed, planning, scheduling, running, finishing, queryStartTime, queryEndTime});
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error logging query timeline");
        }
    }

    public void splitCompletionEvent(TaskId taskId, DriverStats driverStats) {
        this.splitCompletionEvent(taskId, driverStats, null, null);
    }

    public void splitFailedEvent(TaskId taskId, DriverStats driverStats, Throwable cause) {
        this.splitCompletionEvent(taskId, driverStats, cause.getClass().getName(), cause.getMessage());
    }

    private void splitCompletionEvent(TaskId taskId, DriverStats driverStats, @Nullable String failureType, @Nullable String failureMessage) {
        Duration timeToStart = null;
        if (driverStats.getStartTime() != null) {
            timeToStart = QueryMonitor.millis(driverStats.getStartTime().getMillis() - driverStats.getCreateTime().getMillis());
        }
        Duration timeToEnd = null;
        if (driverStats.getEndTime() != null) {
            timeToEnd = QueryMonitor.millis(driverStats.getEndTime().getMillis() - driverStats.getCreateTime().getMillis());
        }
        try {
            this.eventClient.post((Object[])new SplitCompletionEvent[]{new SplitCompletionEvent(taskId.getQueryId(), taskId.getStageId(), taskId, this.environment, driverStats.getQueuedTime(), driverStats.getStartTime(), timeToStart, timeToEnd, driverStats.getRawInputDataSize(), driverStats.getRawInputPositions(), driverStats.getElapsedTime(), driverStats.getTotalCpuTime(), driverStats.getTotalUserTime(), failureType, failureMessage, this.objectMapper.writeValueAsString((Object)driverStats))});
        }
        catch (JsonProcessingException e) {
            log.error((Throwable)e, "Error posting split completion event for task %s", new Object[]{taskId});
        }
    }

    private static Duration millis(long millis) {
        if (millis < 0L) {
            millis = 0L;
        }
        return new Duration((double)millis, TimeUnit.MILLISECONDS);
    }
}

