/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class BufferInfo {
    private final String bufferId;
    private final boolean finished;
    private final int bufferedPages;
    private final long pagesSent;

    @JsonCreator
    public BufferInfo(@JsonProperty(value="bufferId") String bufferId, @JsonProperty(value="finished") boolean finished, @JsonProperty(value="bufferedPages") int bufferedPages, @JsonProperty(value="pagesSent") long pagesSent) {
        Preconditions.checkNotNull((Object)bufferId, (Object)"bufferId is null");
        this.bufferId = bufferId;
        this.finished = finished;
        this.bufferedPages = bufferedPages;
        this.pagesSent = pagesSent;
    }

    @JsonProperty
    public String getBufferId() {
        return this.bufferId;
    }

    @JsonProperty
    public boolean isFinished() {
        return this.finished;
    }

    @JsonProperty
    public int getBufferedPages() {
        return this.bufferedPages;
    }

    @JsonProperty
    public long getPagesSent() {
        return this.pagesSent;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BufferInfo other = (BufferInfo)obj;
        return Objects.equal((Object)this.bufferId, (Object)other.bufferId) && Objects.equal((Object)this.finished, (Object)other.finished) && Objects.equal((Object)this.bufferedPages, (Object)other.bufferedPages) && Objects.equal((Object)this.pagesSent, (Object)other.pagesSent);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.bufferId, this.finished, this.bufferedPages, this.pagesSent});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("bufferId", (Object)this.bufferId).add("finished", this.finished).add("bufferedPages", this.bufferedPages).add("pagesSent", this.pagesSent).toString();
    }

    public static Function<BufferInfo, String> bufferIdGetter() {
        return new Function<BufferInfo, String>(){

            public String apply(BufferInfo taskInfo) {
                return taskInfo.getBufferId();
            }
        };
    }
}

