/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.NativeTableHandle;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.ShardManager;
import com.facebook.presto.metadata.TablePartition;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.util.Threads;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.airlift.concurrent.ThreadPoolExecutorMBean;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class DropTableExecution
implements QueryExecution {
    private static final Logger log = Logger.get(DropTableExecution.class);
    private final DropTable statement;
    private final MetadataManager metadataManager;
    private final ShardManager shardManager;
    private final QueryStateMachine stateMachine;

    DropTableExecution(QueryId queryId, String query, Session session, URI self, DropTable statement, MetadataManager metadataManager, ShardManager shardManager, Executor executor) {
        this.statement = statement;
        this.metadataManager = metadataManager;
        this.shardManager = shardManager;
        this.stateMachine = new QueryStateMachine(queryId, query, session, self, executor);
    }

    @Override
    public void start() {
        try {
            if (!this.stateMachine.starting()) {
                return;
            }
            this.stateMachine.recordExecutionStart();
            this.dropTable();
            this.stateMachine.finished();
        }
        catch (RuntimeException e) {
            this.fail(e);
        }
    }

    @Override
    public Duration waitForStateChange(QueryState currentState, Duration maxWait) throws InterruptedException {
        return this.stateMachine.waitForStateChange(currentState, maxWait);
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.stateMachine.addStateChangeListener(stateChangeListener);
    }

    @Override
    public void cancel() {
        this.stateMachine.cancel();
    }

    @Override
    public void fail(Throwable cause) {
        this.stateMachine.fail(cause);
    }

    @Override
    public void cancelStage(StageId stageId) {
    }

    @Override
    public void recordHeartbeat() {
        this.stateMachine.recordHeartbeat();
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.stateMachine.getQueryInfoWithoutDetails();
    }

    private void dropTable() {
        QualifiedTableName tableName = MetadataUtil.createQualifiedTableName(this.stateMachine.getSession(), this.statement.getTableName());
        log.debug("Dropping %s", new Object[]{tableName});
        Optional<TableHandle> tableHandle = this.metadataManager.getTableHandle(tableName);
        Preconditions.checkState((boolean)tableHandle.isPresent(), (String)"Table %s does not exist", (Object[])new Object[]{tableName});
        if (!(tableHandle.get() instanceof NativeTableHandle)) {
            throw new PrestoException(StandardErrorCode.CANNOT_DROP_TABLE.toErrorCode(), "Can only drop native tables");
        }
        Set<TablePartition> partitions = this.shardManager.getPartitions((TableHandle)tableHandle.get());
        for (TablePartition partition : partitions) {
            this.shardManager.dropPartition((TableHandle)tableHandle.get(), partition.getPartitionName());
        }
        this.metadataManager.dropTable((TableHandle)tableHandle.get());
        this.stateMachine.finished();
    }

    public static class DropTableExecutionFactory
    implements QueryExecution.QueryExecutionFactory<DropTableExecution> {
        private final LocationFactory locationFactory;
        private final MetadataManager metadataManager;
        private final ShardManager shardManager;
        private final ExecutorService executor;
        private final ThreadPoolExecutorMBean executorMBean;

        @Inject
        DropTableExecutionFactory(LocationFactory locationFactory, MetadataManager metadataManager, ShardManager shardManager) {
            this.locationFactory = (LocationFactory)Preconditions.checkNotNull((Object)locationFactory, (Object)"locationFactory is null");
            this.metadataManager = (MetadataManager)Preconditions.checkNotNull((Object)metadataManager, (Object)"metadataManager is null");
            this.shardManager = (ShardManager)Preconditions.checkNotNull((Object)shardManager, (Object)"shardManager is null");
            this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed("drop-table-scheduler-%d"));
            this.executorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)this.executor);
        }

        @Managed
        @Nested
        public ThreadPoolExecutorMBean getExecutor() {
            return this.executorMBean;
        }

        @Override
        public DropTableExecution createQueryExecution(QueryId queryId, String query, Session session, Statement statement) {
            return new DropTableExecution(queryId, query, session, this.locationFactory.createQueryLocation(queryId), (DropTable)statement, this.metadataManager, this.shardManager, this.executor);
        }
    }
}

