/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import io.airlift.configuration.Config;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class QueryManagerConfig {
    private int scheduleSplitBatchSize = 1000;
    private int maxPendingSplitsPerNode = 100;
    private int initialHashPartitions = 8;
    private Duration maxQueryAge = new Duration(15.0, TimeUnit.MINUTES);
    private int maxQueryHistory = 100;
    private Duration clientTimeout = new Duration(5.0, TimeUnit.MINUTES);
    private int queryManagerExecutorPoolSize = 5;
    private int remoteTaskMaxConsecutiveErrorCount = 10;
    private Duration remoteTaskMinErrorDuration = new Duration(2.0, TimeUnit.MINUTES);

    @Min(value=1L)
    public int getScheduleSplitBatchSize() {
        return this.scheduleSplitBatchSize;
    }

    @Config(value="query.schedule-split-batch-size")
    public QueryManagerConfig setScheduleSplitBatchSize(int scheduleSplitBatchSize) {
        this.scheduleSplitBatchSize = scheduleSplitBatchSize;
        return this;
    }

    @Min(value=1L)
    public int getMaxPendingSplitsPerNode() {
        return this.maxPendingSplitsPerNode;
    }

    @Config(value="query.max-pending-splits-per-node")
    public QueryManagerConfig setMaxPendingSplitsPerNode(int maxPendingSplitsPerNode) {
        this.maxPendingSplitsPerNode = maxPendingSplitsPerNode;
        return this;
    }

    @Min(value=1L)
    public int getInitialHashPartitions() {
        return this.initialHashPartitions;
    }

    @Config(value="query.initial-hash-partitions")
    public QueryManagerConfig setInitialHashPartitions(int initialHashPartitions) {
        this.initialHashPartitions = initialHashPartitions;
        return this;
    }

    @NotNull
    public Duration getMaxQueryAge() {
        return this.maxQueryAge;
    }

    @Config(value="query.max-age")
    public QueryManagerConfig setMaxQueryAge(Duration maxQueryAge) {
        this.maxQueryAge = maxQueryAge;
        return this;
    }

    @Min(value=0L)
    public int getMaxQueryHistory() {
        return this.maxQueryHistory;
    }

    @Config(value="query.max-history")
    public QueryManagerConfig setMaxQueryHistory(int maxQueryHistory) {
        this.maxQueryHistory = maxQueryHistory;
        return this;
    }

    @MinDuration(value="5s")
    @NotNull
    public Duration getClientTimeout() {
        return this.clientTimeout;
    }

    @Config(value="query.client.timeout")
    public QueryManagerConfig setClientTimeout(Duration clientTimeout) {
        this.clientTimeout = clientTimeout;
        return this;
    }

    @Min(value=1L)
    public int getQueryManagerExecutorPoolSize() {
        return this.queryManagerExecutorPoolSize;
    }

    @Config(value="query.manager-executor-pool-size")
    public QueryManagerConfig setQueryManagerExecutorPoolSize(int queryManagerExecutorPoolSize) {
        this.queryManagerExecutorPoolSize = queryManagerExecutorPoolSize;
        return this;
    }

    @Min(value=0L)
    public int getRemoteTaskMaxConsecutiveErrorCount() {
        return this.remoteTaskMaxConsecutiveErrorCount;
    }

    @Config(value="query.remote-task.max-consecutive-error-count")
    public QueryManagerConfig setRemoteTaskMaxConsecutiveErrorCount(int remoteTaskMaxConsecutiveErrorCount) {
        this.remoteTaskMaxConsecutiveErrorCount = remoteTaskMaxConsecutiveErrorCount;
        return this;
    }

    @NotNull
    public Duration getRemoteTaskMinErrorDuration() {
        return this.remoteTaskMinErrorDuration;
    }

    @Config(value="query.remote-task.min-error-duration")
    public QueryManagerConfig setRemoteTaskMinErrorDuration(Duration remoteTaskMinErrorDuration) {
        this.remoteTaskMinErrorDuration = remoteTaskMinErrorDuration;
        return this;
    }
}

