/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.google.common.base.Predicate;

public enum QueryState {
    QUEUED(false),
    PLANNING(false),
    STARTING(false),
    RUNNING(false),
    FINISHED(true),
    CANCELED(true),
    FAILED(true);

    private final boolean doneState;

    private QueryState(boolean doneState) {
        this.doneState = doneState;
    }

    public boolean isDone() {
        return this.doneState;
    }

    public static Predicate<QueryState> inDoneState() {
        return new Predicate<QueryState>(){

            public boolean apply(QueryState state) {
                return state.isDone();
            }
        };
    }
}

