/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.spi.Split;
import com.facebook.presto.spi.SplitSource;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;

public class SampledSplitSource
implements SplitSource {
    private final SplitSource splitSource;
    private final double sampleRatio;

    public SampledSplitSource(SplitSource splitSource, double sampleRatio) {
        this.splitSource = (SplitSource)Preconditions.checkNotNull((Object)splitSource, (Object)"dataSource is null");
        this.sampleRatio = sampleRatio;
    }

    @Nullable
    public String getDataSourceName() {
        return this.splitSource.getDataSourceName();
    }

    public List<Split> getNextBatch(int maxSize) throws InterruptedException {
        List nextBatch = this.splitSource.getNextBatch(maxSize);
        Iterable sampleIterable = Iterables.filter((Iterable)nextBatch, (Predicate)new Predicate<Split>(){

            public boolean apply(@Nullable Split input) {
                return ThreadLocalRandom.current().nextDouble() < SampledSplitSource.this.sampleRatio;
            }
        });
        return ImmutableList.copyOf((Iterable)sampleIterable);
    }

    public boolean isFinished() {
        return this.splitSource.isFinished();
    }
}

