/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.spi.StandardErrorCode;
import io.airlift.stats.CounterStat;
import io.airlift.stats.DistributionStat;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class SqlQueryManagerStats {
    private final CounterStat startedQueries = new CounterStat();
    private final CounterStat completedQueries = new CounterStat();
    private final CounterStat failedQueries = new CounterStat();
    private final CounterStat userErrorFailures = new CounterStat();
    private final CounterStat internalFailures = new CounterStat();
    private final CounterStat externalFailures = new CounterStat();
    private final CounterStat insufficientResourcesFailures = new CounterStat();
    private final DistributionStat executionTime = new DistributionStat();

    public void queryStarted() {
        this.startedQueries.update(1L);
    }

    public void queryFinished(QueryInfo info) {
        this.completedQueries.update(1L);
        this.executionTime.add(info.getQueryStats().getEndTime().getMillis() - info.getQueryStats().getCreateTime().getMillis());
        if (info.getErrorCode() != null) {
            switch (StandardErrorCode.toErrorType((int)info.getErrorCode().getCode())) {
                case USER_ERROR: {
                    this.userErrorFailures.update(1L);
                    break;
                }
                case INTERNAL: {
                    this.internalFailures.update(1L);
                    break;
                }
                case INSUFFICIENT_RESOURCES: {
                    this.insufficientResourcesFailures.update(1L);
                    break;
                }
                case EXTERNAL: {
                    this.externalFailures.update(1L);
                }
            }
            this.failedQueries.update(1L);
        }
    }

    @Managed
    public long getRunningQueries() {
        return Math.max(0L, this.startedQueries.getTotalCount() - this.completedQueries.getTotalCount());
    }

    @Managed
    @Nested
    public CounterStat getStartedQueries() {
        return this.startedQueries;
    }

    @Managed
    @Nested
    public CounterStat getCompletedQueries() {
        return this.completedQueries;
    }

    @Managed
    @Nested
    public CounterStat getFailedQueries() {
        return this.failedQueries;
    }

    @Managed
    @Nested
    public DistributionStat getExecutionTime() {
        return this.executionTime;
    }

    @Managed
    @Nested
    public CounterStat getUserErrorFailures() {
        return this.userErrorFailures;
    }

    @Managed
    @Nested
    public CounterStat getInternalFailures() {
        return this.internalFailures;
    }

    @Managed
    @Nested
    public CounterStat getExternalFailures() {
        return this.externalFailures;
    }

    @Managed
    @Nested
    public CounterStat getInsufficientResourcesFailures() {
        return this.insufficientResourcesFailures;
    }
}

