/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.HashPagePartitionFunction;
import com.facebook.presto.OutputBuffers;
import com.facebook.presto.PagePartitionFunction;
import com.facebook.presto.UnpartitionedPagePartitionFunction;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.NodeScheduler;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.StageExecutionNode;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.StageState;
import com.facebook.presto.execution.StageStats;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.Split;
import com.facebook.presto.spi.SplitSource;
import com.facebook.presto.split.RemoteSplit;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.StageExecutionPlan;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.IterableTransformer;
import com.facebook.presto.util.SetThreadName;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.log.Logger;
import io.airlift.stats.Distribution;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;

@ThreadSafe
public class SqlStageExecution
implements StageExecutionNode {
    private static final Logger log = Logger.get(SqlStageExecution.class);
    @Nullable
    private final StageExecutionNode parent;
    private final StageId stageId;
    private final URI location;
    private final PlanFragment fragment;
    private final List<TupleInfo> tupleInfos;
    private final Map<PlanFragmentId, StageExecutionNode> subStages;
    private final ConcurrentMap<Node, RemoteTask> tasks = new ConcurrentHashMap<Node, RemoteTask>();
    private final Optional<SplitSource> dataSource;
    private final RemoteTaskFactory remoteTaskFactory;
    private final Session session;
    private final int splitBatchSize;
    private final int initialHashPartitions;
    private final StateMachine<StageState> stageState;
    private final LinkedBlockingQueue<Throwable> failureCauses = new LinkedBlockingQueue();
    private final Set<PlanNodeId> completeSources = new HashSet<PlanNodeId>();
    @GuardedBy(value="this")
    private OutputBuffers currentOutputBuffers = OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS;
    @GuardedBy(value="this")
    private OutputBuffers nextOutputBuffers;
    private final ExecutorService executor;
    private final AtomicReference<DateTime> schedulingComplete = new AtomicReference();
    private final Distribution getSplitDistribution = new Distribution();
    private final Distribution scheduleTaskDistribution = new Distribution();
    private final Distribution addSplitDistribution = new Distribution();
    private final NodeScheduler.NodeSelector nodeSelector;
    private final AtomicReference<Multimap<PlanNodeId, URI>> exchangeLocations = new AtomicReference<ImmutableMultimap>(ImmutableMultimap.of());

    public SqlStageExecution(QueryId queryId, LocationFactory locationFactory, StageExecutionPlan plan, NodeScheduler nodeScheduler, RemoteTaskFactory remoteTaskFactory, Session session, int splitBatchSize, int maxPendingSplitsPerNode, int initialHashPartitions, ExecutorService executor, OutputBuffers nextOutputBuffers) {
        this(null, queryId, new AtomicInteger(), locationFactory, plan, nodeScheduler, remoteTaskFactory, session, splitBatchSize, maxPendingSplitsPerNode, initialHashPartitions, executor);
        this.nextOutputBuffers = nextOutputBuffers;
    }

    private SqlStageExecution(@Nullable StageExecutionNode parent, QueryId queryId, AtomicInteger nextStageId, LocationFactory locationFactory, StageExecutionPlan plan, NodeScheduler nodeScheduler, RemoteTaskFactory remoteTaskFactory, Session session, int splitBatchSize, int maxPendingSplitsPerNode, int initialHashPartitions, ExecutorService executor) {
        Preconditions.checkNotNull((Object)queryId, (Object)"queryId is null");
        Preconditions.checkNotNull((Object)nextStageId, (Object)"nextStageId is null");
        Preconditions.checkNotNull((Object)locationFactory, (Object)"locationFactory is null");
        Preconditions.checkNotNull((Object)plan, (Object)"plan is null");
        Preconditions.checkNotNull((Object)nodeScheduler, (Object)"nodeScheduler is null");
        Preconditions.checkNotNull((Object)remoteTaskFactory, (Object)"remoteTaskFactory is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkArgument((initialHashPartitions > 0 ? 1 : 0) != 0, (Object)"initialHashPartitions must be greater than 0");
        Preconditions.checkArgument((maxPendingSplitsPerNode > 0 ? 1 : 0) != 0, (Object)"maxPendingSplitsPerNode must be greater than 0");
        Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
        this.stageId = new StageId(queryId, String.valueOf(nextStageId.getAndIncrement()));
        try (SetThreadName setThreadName = new SetThreadName("Stage-%s", this.stageId);){
            this.parent = parent;
            this.location = locationFactory.createStageLocation(this.stageId);
            this.fragment = plan.getFragment();
            this.dataSource = plan.getDataSource();
            this.remoteTaskFactory = remoteTaskFactory;
            this.session = session;
            this.splitBatchSize = splitBatchSize;
            this.initialHashPartitions = initialHashPartitions;
            this.executor = executor;
            this.tupleInfos = this.fragment.getTupleInfos();
            ImmutableMap.Builder subStages = ImmutableMap.builder();
            for (StageExecutionPlan subStagePlan : plan.getSubStages()) {
                PlanFragmentId subStageFragmentId = subStagePlan.getFragment().getId();
                SqlStageExecution subStage = new SqlStageExecution(this, queryId, nextStageId, locationFactory, subStagePlan, nodeScheduler, remoteTaskFactory, session, splitBatchSize, maxPendingSplitsPerNode, initialHashPartitions, executor);
                subStage.addStateChangeListener(new StateMachine.StateChangeListener<StageInfo>(){

                    @Override
                    public void stateChanged(StageInfo stageInfo) {
                        SqlStageExecution.this.doUpdateState();
                    }
                });
                subStages.put((Object)subStageFragmentId, (Object)subStage);
            }
            this.subStages = subStages.build();
            String dataSourceName = this.dataSource.isPresent() ? ((SplitSource)this.dataSource.get()).getDataSourceName() : null;
            this.nodeSelector = nodeScheduler.createNodeSelector(dataSourceName, this.tasks, maxPendingSplitsPerNode);
            this.stageState = new StateMachine<StageState>("stage " + this.stageId, this.executor, StageState.PLANNED);
            this.stageState.addStateChangeListener(new StateMachine.StateChangeListener<StageState>(){

                @Override
                public void stateChanged(StageState newValue) {
                    log.debug("Stage %s is %s", new Object[]{SqlStageExecution.this.stageId, newValue});
                }
            });
        }
    }

    @Override
    public void cancelStage(StageId stageId) {
        try (SetThreadName setThreadName = new SetThreadName("Stage-%s", stageId);){
            if (stageId.equals(this.stageId)) {
                this.cancel(true);
            } else {
                for (StageExecutionNode subStage : this.subStages.values()) {
                    subStage.cancelStage(stageId);
                }
            }
        }
    }

    @Override
    @VisibleForTesting
    public StageState getState() {
        try (SetThreadName setThreadName = new SetThreadName("Stage-%s", this.stageId);){
            StageState stageState = this.stageState.get();
            return stageState;
        }
    }

    @Override
    public StageInfo getStageInfo() {
        try (SetThreadName setThreadName = new SetThreadName("Stage-%s", this.stageId);){
            StageState state = this.stageState.get();
            List<TaskInfo> taskInfos = IterableTransformer.on(this.tasks.values()).transform(SqlStageExecution.taskInfoGetter()).list();
            List<StageInfo> subStageInfos = IterableTransformer.on(this.subStages.values()).transform(SqlStageExecution.stageInfoGetter()).list();
            int totalTasks = taskInfos.size();
            int runningTasks = 0;
            int completedTasks = 0;
            int totalDrivers = 0;
            int queuedDrivers = 0;
            int runningDrivers = 0;
            int completedDrivers = 0;
            long totalMemoryReservation = 0L;
            long totalScheduledTime = 0L;
            long totalCpuTime = 0L;
            long totalUserTime = 0L;
            long totalBlockedTime = 0L;
            long rawInputDataSize = 0L;
            long rawInputPositions = 0L;
            long processedInputDataSize = 0L;
            long processedInputPositions = 0L;
            long outputDataSize = 0L;
            long outputPositions = 0L;
            for (TaskInfo taskInfo : taskInfos) {
                if (taskInfo.getState().isDone()) {
                    ++completedTasks;
                } else {
                    ++runningTasks;
                }
                TaskStats taskStats = taskInfo.getStats();
                totalDrivers += taskStats.getTotalDrivers();
                queuedDrivers += taskStats.getQueuedDrivers();
                runningDrivers += taskStats.getRunningDrivers();
                completedDrivers += taskStats.getCompletedDrivers();
                totalMemoryReservation += taskStats.getMemoryReservation().toBytes();
                totalScheduledTime += taskStats.getTotalScheduledTime().roundTo(TimeUnit.NANOSECONDS);
                totalCpuTime += taskStats.getTotalCpuTime().roundTo(TimeUnit.NANOSECONDS);
                totalUserTime += taskStats.getTotalUserTime().roundTo(TimeUnit.NANOSECONDS);
                totalBlockedTime += taskStats.getTotalBlockedTime().roundTo(TimeUnit.NANOSECONDS);
                rawInputDataSize += taskStats.getRawInputDataSize().toBytes();
                rawInputPositions += taskStats.getRawInputPositions();
                processedInputDataSize += taskStats.getProcessedInputDataSize().toBytes();
                processedInputPositions += taskStats.getProcessedInputPositions();
                outputDataSize += taskStats.getOutputDataSize().toBytes();
                outputPositions += taskStats.getOutputPositions();
            }
            StageStats stageStats = new StageStats(this.schedulingComplete.get(), this.getSplitDistribution.snapshot(), this.scheduleTaskDistribution.snapshot(), this.addSplitDistribution.snapshot(), totalTasks, runningTasks, completedTasks, totalDrivers, queuedDrivers, runningDrivers, completedDrivers, new DataSize((double)totalMemoryReservation, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), new Duration((double)totalScheduledTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalCpuTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalUserTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalBlockedTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new DataSize((double)rawInputDataSize, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), rawInputPositions, new DataSize((double)processedInputDataSize, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), processedInputPositions, new DataSize((double)outputDataSize, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), outputPositions);
            StageInfo stageInfo = new StageInfo(this.stageId, state, this.location, this.fragment, this.tupleInfos, stageStats, taskInfos, subStageInfos, Failures.toFailures(this.failureCauses));
            return stageInfo;
        }
    }

    @Override
    public synchronized void parentNodesAdded(List<Node> parentNodes, boolean noMoreParentNodes) {
        OutputBuffers newOutputBuffers;
        OutputBuffers startingOutputBuffers;
        Preconditions.checkNotNull(parentNodes, (Object)"parentNodes is null");
        OutputBuffers outputBuffers = startingOutputBuffers = this.nextOutputBuffers != null ? this.nextOutputBuffers : this.currentOutputBuffers;
        if (this.fragment.getOutputPartitioning() == PlanFragment.OutputPartitioning.NONE) {
            ImmutableMap.Builder newBuffers = ImmutableMap.builder();
            for (Node parentNode : parentNodes) {
                newBuffers.put((Object)parentNode.getNodeIdentifier(), (Object)new UnpartitionedPagePartitionFunction());
            }
            newOutputBuffers = startingOutputBuffers.withBuffers((Map<String, PagePartitionFunction>)newBuffers.build());
            if (noMoreParentNodes) {
                newOutputBuffers = newOutputBuffers.withNoMoreBufferIds();
            }
        } else if (this.fragment.getOutputPartitioning() == PlanFragment.OutputPartitioning.HASH) {
            Preconditions.checkArgument((boolean)noMoreParentNodes, (Object)"Hash partitioned output requires all parent nodes be added in a single call");
            ImmutableMap.Builder buffers = ImmutableMap.builder();
            for (int nodeIndex = 0; nodeIndex < parentNodes.size(); ++nodeIndex) {
                Node node = parentNodes.get(nodeIndex);
                buffers.put((Object)node.getNodeIdentifier(), (Object)new HashPagePartitionFunction(nodeIndex, parentNodes.size(), this.fragment.getPartitioningChannels()));
            }
            newOutputBuffers = startingOutputBuffers.withBuffers((Map<String, PagePartitionFunction>)buffers.build()).withNoMoreBufferIds();
        } else {
            throw new UnsupportedOperationException("Unsupported output partitioning " + (Object)((Object)this.fragment.getOutputPartitioning()));
        }
        if (newOutputBuffers.getVersion() != startingOutputBuffers.getVersion()) {
            this.nextOutputBuffers = newOutputBuffers;
            this.notifyAll();
        }
    }

    public synchronized OutputBuffers getCurrentOutputBuffers() {
        return this.currentOutputBuffers;
    }

    public synchronized OutputBuffers updateToNextOutputBuffers() {
        if (this.nextOutputBuffers == null) {
            return this.currentOutputBuffers;
        }
        this.currentOutputBuffers = this.nextOutputBuffers;
        this.nextOutputBuffers = null;
        return this.currentOutputBuffers;
    }

    @Override
    public void addStateChangeListener(final StateMachine.StateChangeListener<StageInfo> stateChangeListener) {
        try (SetThreadName setThreadName = new SetThreadName("Stage-%s", this.stageId);){
            this.stageState.addStateChangeListener(new StateMachine.StateChangeListener<StageState>(){

                @Override
                public void stateChanged(StageState newValue) {
                    stateChangeListener.stateChanged(SqlStageExecution.this.getStageInfo());
                }
            });
        }
    }

    private Multimap<PlanNodeId, URI> getNewExchangeLocations() {
        Multimap<PlanNodeId, URI> exchangeLocations = this.exchangeLocations.get();
        ImmutableMultimap.Builder newExchangeLocations = ImmutableMultimap.builder();
        for (PlanNode planNode : this.fragment.getSources()) {
            if (!(planNode instanceof ExchangeNode)) continue;
            ExchangeNode exchangeNode = (ExchangeNode)planNode;
            for (PlanFragmentId planFragmentId : exchangeNode.getSourceFragmentIds()) {
                StageExecutionNode subStage = this.subStages.get(planFragmentId);
                Preconditions.checkState((subStage != null ? 1 : 0) != 0, (String)"Unknown sub stage %s, known stages %s", (Object[])new Object[]{planFragmentId, this.subStages.keySet()});
                for (URI uRI : subStage.getTaskLocations()) {
                    if (exchangeLocations.containsEntry((Object)exchangeNode.getId(), (Object)uRI)) continue;
                    newExchangeLocations.putAll((Object)exchangeNode.getId(), (Object[])new URI[]{uRI});
                }
            }
        }
        return newExchangeLocations.build();
    }

    @VisibleForTesting
    public synchronized List<URI> getTaskLocations() {
        try (SetThreadName setThreadName = new SetThreadName("Stage-%s", this.stageId);){
            ImmutableList.Builder locations = ImmutableList.builder();
            for (RemoteTask task : this.tasks.values()) {
                locations.add((Object)task.getTaskInfo().getSelf());
            }
            ImmutableList immutableList = locations.build();
            return immutableList;
        }
    }

    @VisibleForTesting
    public Map<Node, RemoteTask> getTasks() {
        return ImmutableMap.copyOf(this.tasks);
    }

    public Future<?> start() {
        try (SetThreadName setThreadName = new SetThreadName("Stage-%s", this.stageId);){
            Future<?> future = this.scheduleStartTasks();
            return future;
        }
    }

    @Override
    @VisibleForTesting
    public Future<?> scheduleStartTasks() {
        try (SetThreadName setThreadName = new SetThreadName("Stage-%s", this.stageId);){
            for (StageExecutionNode subStage : this.subStages.values()) {
                subStage.scheduleStartTasks();
            }
            Future<?> future = this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    SqlStageExecution.this.startTasks();
                }
            });
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void startTasks() {
        try (SetThreadName setThreadName = new SetThreadName("Stage-%s", this.stageId);){
            try {
                Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not start while holding a lock on this");
                SqlStageExecution sqlStageExecution = this;
                // MONITORENTER : sqlStageExecution
                if (!this.stageState.compareAndSet(StageState.PLANNED, StageState.SCHEDULING)) {
                    // MONITOREXIT : sqlStageExecution
                    this.doUpdateState();
                    return;
                }
                // MONITOREXIT : sqlStageExecution
                if (this.fragment.getDistribution() == PlanFragment.PlanDistribution.NONE) {
                    this.scheduleFixedNodeCount(1);
                } else if (this.fragment.getDistribution() == PlanFragment.PlanDistribution.FIXED) {
                    this.scheduleFixedNodeCount(this.initialHashPartitions);
                } else if (this.fragment.getDistribution() == PlanFragment.PlanDistribution.SOURCE) {
                    this.scheduleSourcePartitionedNodes();
                } else {
                    if (this.fragment.getDistribution() != PlanFragment.PlanDistribution.COORDINATOR_ONLY) throw new IllegalStateException("Unsupported partitioning: " + (Object)((Object)this.fragment.getDistribution()));
                    this.scheduleOnCurrentNode();
                }
                this.schedulingComplete.set(DateTime.now());
                this.stageState.set(StageState.SCHEDULED);
                this.updateNewExchangesAndBuffers(true);
                this.doUpdateState();
                return;
            }
            catch (Throwable e) {
                try {
                    if (!this.getState().isDone()) {
                        SqlStageExecution sqlStageExecution = this;
                        // MONITORENTER : sqlStageExecution
                        this.failureCauses.add(e);
                        this.stageState.set(StageState.FAILED);
                        // MONITOREXIT : sqlStageExecution
                        log.error(e, "Error while starting stage %s", new Object[]{this.stageId});
                        this.cancel(true);
                        if (!(e instanceof InterruptedException)) throw Throwables.propagate((Throwable)e);
                        Thread.currentThread().interrupt();
                        throw Throwables.propagate((Throwable)e);
                    }
                    Throwables.propagateIfInstanceOf((Throwable)e, Error.class);
                    log.debug(e, "Error while starting stage in done query %s", new Object[]{this.stageId});
                    return;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.doUpdateState();
                }
            }
        }
    }

    private void scheduleFixedNodeCount(int nodeCount) {
        List<Node> nodes = this.nodeSelector.selectRandomNodes(nodeCount);
        for (int taskId = 0; taskId < nodes.size(); ++taskId) {
            Node node = nodes.get(taskId);
            this.scheduleTask(taskId, node);
        }
        for (StageExecutionNode subStage : this.subStages.values()) {
            subStage.parentNodesAdded(nodes, true);
        }
    }

    private void scheduleOnCurrentNode() {
        Node node = this.nodeSelector.selectCurrentNode();
        this.scheduleTask(0, node);
        for (StageExecutionNode subStage : this.subStages.values()) {
            subStage.parentNodesAdded((List<Node>)ImmutableList.of((Object)node), true);
        }
    }

    private void scheduleSourcePartitionedNodes() throws InterruptedException {
        AtomicInteger nextTaskId = new AtomicInteger(0);
        long getSplitStart = System.nanoTime();
        SplitSource splitSource = (SplitSource)this.dataSource.get();
        while (!splitSource.isFinished()) {
            this.getSplitDistribution.add(System.nanoTime() - getSplitStart);
            if (this.getState().isDone()) break;
            ImmutableSet pendingSplits = ImmutableSet.copyOf((Collection)splitSource.getNextBatch(this.splitBatchSize));
            while (!pendingSplits.isEmpty() && !this.getState().isDone()) {
                Multimap<Node, Split> splitAssignment = this.nodeSelector.computeAssignments((Set<Split>)pendingSplits);
                pendingSplits = ImmutableSet.copyOf((Collection)Sets.difference((Set)pendingSplits, (Set)ImmutableSet.copyOf((Collection)splitAssignment.values())));
                this.assignSplits(nextTaskId, splitAssignment);
                if (pendingSplits.isEmpty()) continue;
                this.waitForFreeNode(nextTaskId);
            }
        }
        for (RemoteTask task : this.tasks.values()) {
            task.noMoreSplits(this.fragment.getPartitionedSource());
        }
        this.completeSources.add(this.fragment.getPartitionedSource());
        this.setNoMoreStageNodes();
    }

    private void assignSplits(AtomicInteger nextTaskId, Multimap<Node, Split> splitAssignment) {
        for (Map.Entry taskSplits : splitAssignment.asMap().entrySet()) {
            long scheduleSplitStart = System.nanoTime();
            Node node = (Node)taskSplits.getKey();
            RemoteTask task = (RemoteTask)this.tasks.get(node);
            if (task == null) {
                this.scheduleTask(nextTaskId.getAndIncrement(), node, this.fragment.getPartitionedSource(), (Iterable)taskSplits.getValue());
                this.addStageNode(node);
                this.scheduleTaskDistribution.add(System.nanoTime() - scheduleSplitStart);
                continue;
            }
            task.addSplits(this.fragment.getPartitionedSource(), (Iterable)taskSplits.getValue());
            this.addSplitDistribution.add(System.nanoTime() - scheduleSplitStart);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForFreeNode(AtomicInteger nextTaskId) {
        if (!this.subStages.isEmpty()) {
            this.nodeSelector.lockDownNodes();
            for (Node node : Sets.difference(new HashSet<Node>(this.nodeSelector.allNodes()), this.tasks.keySet())) {
                this.scheduleTask(nextTaskId.getAndIncrement(), node);
            }
            this.setNoMoreStageNodes();
        }
        SqlStageExecution sqlStageExecution = this;
        synchronized (sqlStageExecution) {
            try {
                TimeUnit.SECONDS.timedWait(this, 1L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate((Throwable)e);
            }
        }
        this.updateNewExchangesAndBuffers(false);
    }

    private void addStageNode(Node node) {
        for (StageExecutionNode subStage : this.subStages.values()) {
            subStage.parentNodesAdded((List<Node>)ImmutableList.of((Object)node), false);
        }
    }

    private void setNoMoreStageNodes() {
        for (StageExecutionNode subStage : this.subStages.values()) {
            subStage.parentNodesAdded((List<Node>)ImmutableList.of(), true);
        }
    }

    private RemoteTask scheduleTask(int id, Node node) {
        return this.scheduleTask(id, node, null, (Iterable<? extends Split>)ImmutableList.of());
    }

    private RemoteTask scheduleTask(int id, Node node, PlanNodeId sourceId, Iterable<? extends Split> sourceSplits) {
        this.addNewExchangesAndBuffers();
        TaskId taskId = new TaskId(this.stageId, String.valueOf(id));
        ImmutableMultimap.Builder initialSplits = ImmutableMultimap.builder();
        for (Split split : sourceSplits) {
            initialSplits.put((Object)sourceId, (Object)split);
        }
        for (Map.Entry entry : this.exchangeLocations.get().entries()) {
            initialSplits.put(entry.getKey(), (Object)this.createRemoteSplitFor(node.getNodeIdentifier(), (URI)entry.getValue()));
        }
        RemoteTask task = this.remoteTaskFactory.createRemoteTask(this.session, taskId, node, this.fragment, (Multimap<PlanNodeId, Split>)initialSplits.build(), this.currentOutputBuffers);
        task.addStateChangeListener(new StateMachine.StateChangeListener<TaskInfo>(){

            @Override
            public void stateChanged(TaskInfo taskInfo) {
                SqlStageExecution.this.doUpdateState();
            }
        });
        task.start();
        this.tasks.put(node, task);
        this.doUpdateState();
        if (this.getState().isDone()) {
            return task;
        }
        return task;
    }

    private void updateNewExchangesAndBuffers(boolean waitUntilFinished) {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not add exchanges or buffers to tasks while holding a lock on this");
        while (!this.getState().isDone()) {
            boolean finished = this.addNewExchangesAndBuffers();
            if (finished || !waitUntilFinished) {
                return;
            }
            this.waitForNewExchangesOrBuffers();
        }
    }

    private boolean addNewExchangesAndBuffers() {
        Set<PlanNodeId> completeSources = this.updateCompleteSources();
        boolean allSourceComplete = completeSources.containsAll(this.fragment.getSourceIds());
        Multimap<PlanNodeId, URI> newExchangeLocations = this.getNewExchangeLocations();
        this.exchangeLocations.set((Multimap<PlanNodeId, URI>)ImmutableMultimap.builder().putAll(this.exchangeLocations.get()).putAll(newExchangeLocations).build());
        OutputBuffers outputBuffers = this.updateToNextOutputBuffers();
        boolean finished = allSourceComplete && outputBuffers.isNoMoreBufferIds();
        for (RemoteTask task : this.tasks.values()) {
            for (Map.Entry entry : newExchangeLocations.entries()) {
                RemoteSplit remoteSplit = this.createRemoteSplitFor(task.getNodeId(), (URI)entry.getValue());
                task.addSplits((PlanNodeId)entry.getKey(), (Iterable<? extends Split>)ImmutableList.of((Object)remoteSplit));
            }
            task.setOutputBuffers(outputBuffers);
            for (PlanNodeId completeSource : completeSources) {
                task.noMoreSplits(completeSource);
            }
        }
        return finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void waitForNewExchangesOrBuffers() {
        while (!this.getState().isDone()) {
            Set<PlanNodeId> completeSources = this.updateCompleteSources();
            boolean allSourceComplete = completeSources.containsAll(this.fragment.getSourceIds());
            if (allSourceComplete && this.getCurrentOutputBuffers().isNoMoreBufferIds()) {
                return;
            }
            SqlStageExecution sqlStageExecution = this;
            synchronized (sqlStageExecution) {
                if (this.nextOutputBuffers != null) {
                    return;
                }
            }
            if (!this.getNewExchangeLocations().isEmpty()) {
                return;
            }
            try {
                TimeUnit.SECONDS.timedWait(this, 1L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private Set<PlanNodeId> updateCompleteSources() {
        for (PlanNode planNode : this.fragment.getSources()) {
            if (this.completeSources.contains(planNode.getId()) || !(planNode instanceof ExchangeNode)) continue;
            ExchangeNode exchangeNode = (ExchangeNode)planNode;
            boolean exchangeFinished = true;
            for (PlanFragmentId planFragmentId : exchangeNode.getSourceFragmentIds()) {
                StageExecutionNode subStage = this.subStages.get(planFragmentId);
                switch (subStage.getState()) {
                    case PLANNED: 
                    case SCHEDULING: {
                        exchangeFinished = false;
                    }
                }
            }
            if (!exchangeFinished) continue;
            this.completeSources.add(planNode.getId());
        }
        return this.completeSources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void doUpdateState() {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not doUpdateState while holding a lock on this");
        try (SetThreadName setThreadName = new SetThreadName("Stage-%s", this.stageId);){
            SqlStageExecution sqlStageExecution = this;
            synchronized (sqlStageExecution) {
                StageState currentState;
                block28: {
                    this.notifyAll();
                    currentState = this.stageState.get();
                    if (!currentState.isDone()) break block28;
                    return;
                }
                ImmutableList subStageStates = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Iterables.transform(this.subStages.values(), SqlStageExecution.stageInfoGetter()), StageInfo.stageStateGetter()));
                if (Iterables.any((Iterable)subStageStates, (Predicate)Predicates.equalTo((Object)((Object)StageState.FAILED)))) {
                    this.stageState.set(StageState.FAILED);
                } else {
                    ImmutableList taskStates = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Iterables.transform(this.tasks.values(), SqlStageExecution.taskInfoGetter()), TaskInfo.taskStateGetter()));
                    if (Iterables.any((Iterable)taskStates, (Predicate)Predicates.equalTo((Object)((Object)TaskState.FAILED)))) {
                        this.stageState.set(StageState.FAILED);
                    } else if (currentState != StageState.PLANNED && currentState != StageState.SCHEDULING) {
                        if (Iterables.all((Iterable)taskStates, TaskState.inDoneState())) {
                            this.stageState.set(StageState.FINISHED);
                        } else if (Iterables.any((Iterable)taskStates, (Predicate)Predicates.equalTo((Object)((Object)TaskState.RUNNING)))) {
                            this.stageState.set(StageState.RUNNING);
                        }
                    }
                }
            }
            if (this.stageState.get().isDone()) {
                this.cancel(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(boolean force) {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not cancel while holding a lock on this");
        try (SetThreadName setThreadName = new SetThreadName("Stage-%s", this.stageId);){
            SqlStageExecution waitTime;
            if (!force) {
                waitTime = new Duration(100.0, TimeUnit.MILLISECONDS);
                for (RemoteTask remoteTask : this.tasks.values()) {
                    try {
                        waitTime = remoteTask.waitForTaskToFinish((Duration)waitTime);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            }
            this.doUpdateState();
            waitTime = this;
            synchronized (waitTime) {
                if (!this.stageState.get().isDone()) {
                    log.debug("Cancelling stage %s", new Object[]{this.stageId});
                    this.stageState.set(StageState.CANCELED);
                }
            }
            for (RemoteTask task : this.tasks.values()) {
                task.cancel();
            }
            for (StageExecutionNode subStage : this.subStages.values()) {
                subStage.cancel(force);
            }
        }
    }

    private RemoteSplit createRemoteSplitFor(String nodeId, URI taskLocation) {
        URI splitLocation = HttpUriBuilder.uriBuilderFrom((URI)taskLocation).appendPath("results").appendPath(nodeId).build();
        return new RemoteSplit(splitLocation, this.tupleInfos);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("stageId", (Object)this.stageId).add("location", (Object)this.location).add("stageState", (Object)this.stageState.get()).toString();
    }

    public static Function<RemoteTask, TaskInfo> taskInfoGetter() {
        return new Function<RemoteTask, TaskInfo>(){

            public TaskInfo apply(RemoteTask remoteTask) {
                return remoteTask.getTaskInfo();
            }
        };
    }

    public static Function<StageExecutionNode, StageInfo> stageInfoGetter() {
        return new Function<StageExecutionNode, StageInfo>(){

            public StageInfo apply(StageExecutionNode stage) {
                return stage.getStageInfo();
            }
        };
    }
}

