/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.ScheduledSplit;
import com.facebook.presto.TaskSource;
import com.facebook.presto.event.query.QueryMonitor;
import com.facebook.presto.execution.BufferResult;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.SharedBuffer;
import com.facebook.presto.execution.SplitRunner;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskExecution;
import com.facebook.presto.execution.TaskExecutor;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.TaskOutputOperator;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.SetThreadName;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.joda.time.DateTime;

public class SqlTaskExecution
implements TaskExecution {
    private final TaskId taskId;
    private final URI location;
    private final TaskExecutor taskExecutor;
    private final Executor notificationExecutor;
    private final TaskStateMachine taskStateMachine;
    private final TaskContext taskContext;
    private final SharedBuffer sharedBuffer;
    private final QueryMonitor queryMonitor;
    private final TaskExecutor.TaskHandle taskHandle;
    private final List<WeakReference<Driver>> drivers = new CopyOnWriteArrayList<WeakReference<Driver>>();
    private final AtomicInteger remainingDrivers = new AtomicInteger();
    @GuardedBy(value="this")
    private final ConcurrentMap<PlanNodeId, TaskSource> unpartitionedSources = new ConcurrentHashMap<PlanNodeId, TaskSource>();
    @GuardedBy(value="this")
    private long maxAcknowledgedSplit = Long.MIN_VALUE;
    private final AtomicReference<DateTime> lastHeartbeat = new AtomicReference<DateTime>(DateTime.now());
    private final PlanNodeId partitionedSourceId;
    private final DriverSplitRunnerFactory partitionedDriverFactory;
    private final List<DriverSplitRunnerFactory> unpartitionedDriverFactories;
    private final AtomicLong nextTaskInfoVersion = new AtomicLong(1L);

    public static SqlTaskExecution createSqlTaskExecution(Session session, TaskId taskId, URI location, PlanFragment fragment, List<TaskSource> sources, OutputBuffers outputBuffers, LocalExecutionPlanner planner, DataSize maxBufferSize, TaskExecutor taskExecutor, ExecutorService notificationExecutor, DataSize maxTaskMemoryUsage, DataSize operatorPreAllocatedMemory, QueryMonitor queryMonitor, boolean cpuTimerEnabled) {
        SqlTaskExecution task = new SqlTaskExecution(session, taskId, location, fragment, outputBuffers, planner, maxBufferSize, taskExecutor, maxTaskMemoryUsage, operatorPreAllocatedMemory, queryMonitor, notificationExecutor, cpuTimerEnabled);
        try (SetThreadName setThreadName = new SetThreadName("Task-%s", taskId);){
            task.start();
            task.addSources(sources);
            task.recordHeartbeat();
            SqlTaskExecution sqlTaskExecution = task;
            return sqlTaskExecution;
        }
    }

    private SqlTaskExecution(Session session, TaskId taskId, URI location, PlanFragment fragment, OutputBuffers outputBuffers, LocalExecutionPlanner planner, DataSize maxBufferSize, TaskExecutor taskExecutor, DataSize maxTaskMemoryUsage, DataSize operatorPreAllocatedMemory, QueryMonitor queryMonitor, Executor notificationExecutor, boolean cpuTimerEnabled) {
        try (SetThreadName setThreadName = new SetThreadName("Task-%s", taskId);){
            this.taskId = (TaskId)Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
            this.location = (URI)Preconditions.checkNotNull((Object)location, (Object)"location is null");
            this.taskExecutor = (TaskExecutor)Preconditions.checkNotNull((Object)taskExecutor, (Object)"driverExecutor is null");
            this.notificationExecutor = (Executor)Preconditions.checkNotNull((Object)notificationExecutor, (Object)"notificationExecutor is null");
            this.taskStateMachine = new TaskStateMachine(taskId, notificationExecutor);
            this.taskStateMachine.addStateChangeListener(new StateMachine.StateChangeListener<TaskState>(){

                @Override
                public void stateChanged(TaskState taskState) {
                    if (taskState.isDone()) {
                        SqlTaskExecution.this.taskExecutor.removeTask(SqlTaskExecution.this.taskHandle);
                        if (taskState != TaskState.FAILED) {
                            SqlTaskExecution.this.sharedBuffer.destroy();
                        }
                    }
                }
            });
            this.taskContext = new TaskContext(this.taskStateMachine, notificationExecutor, session, (DataSize)Preconditions.checkNotNull((Object)maxTaskMemoryUsage, (Object)"maxTaskMemoryUsage is null"), (DataSize)Preconditions.checkNotNull((Object)operatorPreAllocatedMemory, (Object)"operatorPreAllocatedMemory is null"), cpuTimerEnabled);
            this.sharedBuffer = new SharedBuffer(taskId, notificationExecutor, (DataSize)Preconditions.checkNotNull((Object)maxBufferSize, (Object)"maxBufferSize is null"), outputBuffers);
            this.sharedBuffer.addStateChangeListener(new StateMachine.StateChangeListener<SharedBuffer.QueueState>(){

                @Override
                public void stateChanged(SharedBuffer.QueueState taskState) {
                    if (taskState == SharedBuffer.QueueState.FINISHED) {
                        SqlTaskExecution.this.checkTaskCompletion();
                    }
                }
            });
            this.queryMonitor = (QueryMonitor)Preconditions.checkNotNull((Object)queryMonitor, (Object)"queryMonitor is null");
            this.taskHandle = taskExecutor.addTask(taskId);
            LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan = planner.plan(session, fragment.getRoot(), fragment.getSymbols(), new TaskOutputOperator.TaskOutputFactory(this.sharedBuffer));
            List<DriverFactory> driverFactories = localExecutionPlan.getDriverFactories();
            DriverSplitRunnerFactory partitionedDriverFactory = null;
            ImmutableList.Builder unpartitionedDriverFactories = ImmutableList.builder();
            for (DriverFactory driverFactory : driverFactories) {
                if (driverFactory.getSourceIds().contains(fragment.getPartitionedSource())) {
                    Preconditions.checkState((partitionedDriverFactory == null ? 1 : 0) != 0, (Object)"multiple partitioned sources are not supported");
                    partitionedDriverFactory = new DriverSplitRunnerFactory(driverFactory);
                    continue;
                }
                unpartitionedDriverFactories.add((Object)new DriverSplitRunnerFactory(driverFactory));
            }
            this.unpartitionedDriverFactories = unpartitionedDriverFactories.build();
            if (fragment.getDistribution() == PlanFragment.PlanDistribution.SOURCE) {
                Preconditions.checkArgument((partitionedDriverFactory != null ? 1 : 0) != 0, (Object)"Fragment is partitioned, but no partitioned driver found");
            }
            this.partitionedSourceId = fragment.getPartitionedSource();
            this.partitionedDriverFactory = partitionedDriverFactory;
        }
    }

    private void start() {
        ArrayList<DriverSplitRunner> runners = new ArrayList<DriverSplitRunner>();
        for (DriverSplitRunnerFactory driverFactory : this.unpartitionedDriverFactories) {
            runners.add(driverFactory.createDriverRunner(null));
            driverFactory.setNoMoreSplits();
        }
        this.enqueueDrivers(true, runners);
    }

    @Override
    public TaskId getTaskId() {
        return this.taskId;
    }

    @Override
    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    @Override
    public void waitForStateChange(TaskState currentState, Duration maxWait) throws InterruptedException {
        try (SetThreadName setThreadName = new SetThreadName("Task-%s", this.taskId);){
            this.taskStateMachine.waitForStateChange(currentState, maxWait);
        }
    }

    @Override
    public TaskInfo getTaskInfo(boolean full) {
        try (SetThreadName setThreadName = new SetThreadName("Task-%s", this.taskId);){
            this.checkTaskCompletion();
            TaskState state = this.taskStateMachine.getState();
            Object failures = ImmutableList.of();
            if (state == TaskState.FAILED) {
                failures = Failures.toFailures(this.taskStateMachine.getFailureCauses());
            }
            TaskInfo taskInfo = new TaskInfo(this.taskStateMachine.getTaskId(), this.nextTaskInfoVersion.getAndIncrement(), state, this.location, this.lastHeartbeat.get(), this.sharedBuffer.getInfo(), this.getNoMoreSplits(), this.taskContext.getTaskStats(), (List<ExecutionFailureInfo>)failures);
            return taskInfo;
        }
    }

    @Override
    public void addSources(List<TaskSource> sources) {
        Preconditions.checkNotNull(sources, (Object)"sources is null");
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (String)"Can not add sources while holding a lock on the %s", (Object[])new Object[]{this.getClass().getSimpleName()});
        try (SetThreadName setThreadName = new SetThreadName("Task-%s", this.taskId);){
            Map<PlanNodeId, TaskSource> updatedUnpartitionedSources = this.updateSources(sources);
            for (TaskSource source : updatedUnpartitionedSources.values()) {
                for (WeakReference<Driver> driverReference : this.drivers) {
                    Driver driver = (Driver)driverReference.get();
                    if (driver != null) {
                        driver.updateSource(source);
                        continue;
                    }
                    this.drivers.remove(driverReference);
                }
            }
        }
    }

    private synchronized Map<PlanNodeId, TaskSource> updateSources(List<TaskSource> sources) {
        HashMap<PlanNodeId, TaskSource> updatedUnpartitionedSources = new HashMap<PlanNodeId, TaskSource>();
        long newMaxAcknowledgedSplit = this.maxAcknowledgedSplit;
        for (TaskSource source : sources) {
            PlanNodeId sourceId = source.getPlanNodeId();
            if (sourceId.equals(this.partitionedSourceId)) {
                ImmutableList.Builder runners = ImmutableList.builder();
                for (ScheduledSplit scheduledSplit : source.getSplits()) {
                    if (scheduledSplit.getSequenceId() <= this.maxAcknowledgedSplit) continue;
                    runners.add((Object)this.partitionedDriverFactory.createDriverRunner(scheduledSplit));
                    newMaxAcknowledgedSplit = Math.max(scheduledSplit.getSequenceId(), newMaxAcknowledgedSplit);
                }
                this.enqueueDrivers(false, (List<DriverSplitRunner>)runners.build());
                if (!source.isNoMoreSplits()) continue;
                this.partitionedDriverFactory.setNoMoreSplits();
                continue;
            }
            for (ScheduledSplit scheduledSplit : source.getSplits()) {
                newMaxAcknowledgedSplit = Math.max(scheduledSplit.getSequenceId(), newMaxAcknowledgedSplit);
            }
            TaskSource currentSource = (TaskSource)this.unpartitionedSources.get(sourceId);
            TaskSource newSource = currentSource == null ? source : currentSource.update(source);
            if (newSource == currentSource) continue;
            this.unpartitionedSources.put(sourceId, newSource);
            updatedUnpartitionedSources.put(sourceId, newSource);
        }
        this.maxAcknowledgedSplit = newMaxAcknowledgedSplit;
        return updatedUnpartitionedSources;
    }

    @Override
    public synchronized void addResultQueue(OutputBuffers outputBuffers) {
        Preconditions.checkNotNull((Object)outputBuffers, (Object)"outputBuffers is null");
        try (SetThreadName setThreadName = new SetThreadName("Task-%s", this.taskId);){
            this.sharedBuffer.setOutputBuffers(outputBuffers);
        }
    }

    private synchronized void enqueueDrivers(boolean forceRunSplit, List<DriverSplitRunner> runners) {
        List<ListenableFuture<?>> finishedFutures = this.taskExecutor.enqueueSplits(this.taskHandle, forceRunSplit, runners);
        Preconditions.checkState((finishedFutures.size() == runners.size() ? 1 : 0) != 0, (String)"Expected %s futures but got %s", (Object[])new Object[]{runners.size(), finishedFutures.size()});
        this.remainingDrivers.addAndGet(finishedFutures.size());
        for (int i = 0; i < finishedFutures.size(); ++i) {
            ListenableFuture<?> finishedFuture = finishedFutures.get(i);
            final DriverSplitRunner splitRunner = runners.get(i);
            Futures.addCallback(finishedFuture, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(Object result) {
                    try (SetThreadName setThreadName = new SetThreadName("Task-%s", SqlTaskExecution.this.taskId);){
                        SqlTaskExecution.this.remainingDrivers.decrementAndGet();
                        SqlTaskExecution.this.checkTaskCompletion();
                        SqlTaskExecution.this.queryMonitor.splitCompletionEvent(SqlTaskExecution.this.taskId, splitRunner.getDriverContext().getDriverStats());
                    }
                }

                public void onFailure(Throwable cause) {
                    try (SetThreadName setThreadName = new SetThreadName("Task-%s", SqlTaskExecution.this.taskId);){
                        SqlTaskExecution.this.taskStateMachine.failed(cause);
                        SqlTaskExecution.this.remainingDrivers.decrementAndGet();
                        DriverContext driverContext = splitRunner.getDriverContext();
                        DriverStats driverStats = driverContext != null ? driverContext.getDriverStats() : new DriverStats();
                        SqlTaskExecution.this.queryMonitor.splitFailedEvent(SqlTaskExecution.this.taskId, driverStats, cause);
                    }
                }
            }, (Executor)this.notificationExecutor);
        }
    }

    private Set<PlanNodeId> getNoMoreSplits() {
        ImmutableSet.Builder noMoreSplits = ImmutableSet.builder();
        if (this.partitionedDriverFactory != null && this.partitionedDriverFactory.isNoMoreSplits()) {
            noMoreSplits.add((Object)this.partitionedSourceId);
        }
        for (TaskSource taskSource : this.unpartitionedSources.values()) {
            if (!taskSource.isNoMoreSplits()) continue;
            noMoreSplits.add((Object)taskSource.getPlanNodeId());
        }
        return noMoreSplits.build();
    }

    private synchronized void checkTaskCompletion() {
        if (this.taskStateMachine.getState().isDone()) {
            return;
        }
        if (this.partitionedDriverFactory != null && !this.partitionedDriverFactory.isNoMoreSplits()) {
            return;
        }
        if (this.remainingDrivers.get() != 0) {
            return;
        }
        this.sharedBuffer.finish();
        if (!this.sharedBuffer.isFinished()) {
            return;
        }
        this.taskStateMachine.finished();
    }

    @Override
    public void cancel() {
        try (SetThreadName setThreadName = new SetThreadName("Task-%s", this.taskId);){
            this.taskStateMachine.cancel();
        }
    }

    @Override
    public void fail(Throwable cause) {
        try (SetThreadName setThreadName = new SetThreadName("Task-%s", this.taskId);){
            this.taskStateMachine.failed(cause);
        }
    }

    @Override
    public BufferResult getResults(String outputId, long startingSequenceId, DataSize maxSize, Duration maxWait) throws InterruptedException {
        Preconditions.checkNotNull((Object)outputId, (Object)"outputId is null");
        Preconditions.checkArgument((maxSize.toBytes() > 0L ? 1 : 0) != 0, (Object)"maxSize must be at least 1 byte");
        Preconditions.checkNotNull((Object)maxWait, (Object)"maxWait is null");
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (String)"Can not get result data while holding a lock on the %s", (Object[])new Object[]{this.getClass().getSimpleName()});
        try (SetThreadName setThreadName = new SetThreadName("Task-%s", this.taskId);){
            BufferResult bufferResult = this.sharedBuffer.get(outputId, startingSequenceId, maxSize, maxWait);
            return bufferResult;
        }
    }

    @Override
    public void abortResults(String outputId) {
        try (SetThreadName setThreadName = new SetThreadName("Task-%s", this.taskId);){
            this.sharedBuffer.abort(outputId);
        }
    }

    @Override
    public void recordHeartbeat() {
        this.lastHeartbeat.set(DateTime.now());
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("taskId", (Object)this.taskId).add("remainingDrivers", (Object)this.remainingDrivers).add("unpartitionedSources", this.unpartitionedSources).toString();
    }

    private static class DriverSplitRunner
    implements SplitRunner {
        private final DriverSplitRunnerFactory driverSplitRunnerFactory;
        private final DriverContext driverContext;
        @GuardedBy(value="this")
        private boolean closed;
        @Nullable
        private final ScheduledSplit partitionedSplit;
        @GuardedBy(value="this")
        private Driver driver;

        private DriverSplitRunner(DriverSplitRunnerFactory driverSplitRunnerFactory, DriverContext driverContext, @Nullable ScheduledSplit partitionedSplit) {
            this.driverSplitRunnerFactory = (DriverSplitRunnerFactory)Preconditions.checkNotNull((Object)driverSplitRunnerFactory, (Object)"driverFactory is null");
            this.driverContext = (DriverContext)Preconditions.checkNotNull((Object)driverContext, (Object)"driverContext is null");
            this.partitionedSplit = partitionedSplit;
        }

        public synchronized DriverContext getDriverContext() {
            if (this.driver == null) {
                return null;
            }
            return this.driver.getDriverContext();
        }

        @Override
        public synchronized boolean isFinished() {
            return this.driver.isFinished();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListenableFuture<?> processFor(Duration duration) {
            Driver driver;
            DriverSplitRunner driverSplitRunner = this;
            synchronized (driverSplitRunner) {
                if (this.closed) {
                    return Futures.immediateFuture(null);
                }
                if (this.driver == null) {
                    this.driver = this.driverSplitRunnerFactory.createDriver(this.driverContext, this.partitionedSplit);
                }
                driver = this.driver;
            }
            return driver.processFor(duration);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Driver driver;
            DriverSplitRunner driverSplitRunner = this;
            synchronized (driverSplitRunner) {
                this.closed = true;
                driver = this.driver;
            }
            if (driver != null) {
                driver.close();
            }
        }
    }

    private class DriverSplitRunnerFactory {
        private final DriverFactory driverFactory;
        private final PipelineContext pipelineContext;
        private final AtomicInteger pendingCreation = new AtomicInteger();
        private final AtomicBoolean noMoreSplits = new AtomicBoolean();

        private DriverSplitRunnerFactory(DriverFactory driverFactory) {
            this.driverFactory = driverFactory;
            this.pipelineContext = SqlTaskExecution.this.taskContext.addPipelineContext(driverFactory.isInputDriver(), driverFactory.isOutputDriver());
        }

        private DriverSplitRunner createDriverRunner(@Nullable ScheduledSplit partitionedSplit) {
            this.pendingCreation.incrementAndGet();
            DriverContext driverContext = this.pipelineContext.addDriverContext();
            return new DriverSplitRunner(this, driverContext, partitionedSplit);
        }

        private Driver createDriver(DriverContext driverContext, @Nullable ScheduledSplit partitionedSplit) {
            Driver driver = this.driverFactory.createDriver(driverContext);
            SqlTaskExecution.this.drivers.add(new WeakReference<Driver>(driver));
            if (partitionedSplit != null) {
                driver.updateSource(new TaskSource(SqlTaskExecution.this.partitionedSourceId, (Set<ScheduledSplit>)ImmutableSet.of((Object)partitionedSplit), true));
            }
            for (TaskSource source : SqlTaskExecution.this.unpartitionedSources.values()) {
                driver.updateSource(source);
            }
            this.pendingCreation.decrementAndGet();
            this.closeDriverFactoryIfFullyCreated();
            return driver;
        }

        private boolean isNoMoreSplits() {
            return this.noMoreSplits.get();
        }

        private void setNoMoreSplits() {
            this.noMoreSplits.set(true);
            this.closeDriverFactoryIfFullyCreated();
        }

        private void closeDriverFactoryIfFullyCreated() {
            if (this.isNoMoreSplits() && this.pendingCreation.get() <= 0) {
                this.driverFactory.close();
            }
        }
    }
}

