/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StageState;
import com.facebook.presto.execution.StageStats;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.tuple.TupleInfo;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class StageInfo {
    private final StageId stageId;
    private final StageState state;
    private final URI self;
    private final PlanFragment plan;
    private final List<TupleInfo> tupleInfos;
    private final StageStats stageStats;
    private final List<TaskInfo> tasks;
    private final List<StageInfo> subStages;
    private final List<ExecutionFailureInfo> failures;

    @JsonCreator
    public StageInfo(@JsonProperty(value="stageId") StageId stageId, @JsonProperty(value="state") StageState state, @JsonProperty(value="self") URI self, @JsonProperty(value="plan") @Nullable PlanFragment plan, @JsonProperty(value="tupleInfos") List<TupleInfo> tupleInfos, @JsonProperty(value="stageStats") StageStats stageStats, @JsonProperty(value="tasks") List<TaskInfo> tasks, @JsonProperty(value="subStages") List<StageInfo> subStages, @JsonProperty(value="failures") List<ExecutionFailureInfo> failures) {
        Preconditions.checkNotNull((Object)stageId, (Object)"stageId is null");
        Preconditions.checkNotNull((Object)((Object)state), (Object)"state is null");
        Preconditions.checkNotNull((Object)self, (Object)"self is null");
        Preconditions.checkNotNull((Object)stageStats, (Object)"stageStats is null");
        Preconditions.checkNotNull(tasks, (Object)"tasks is null");
        Preconditions.checkNotNull(subStages, (Object)"subStages is null");
        Preconditions.checkNotNull(failures, (Object)"failures is null");
        this.stageId = stageId;
        this.state = state;
        this.self = self;
        this.plan = plan;
        this.tupleInfos = tupleInfos;
        this.stageStats = stageStats;
        this.tasks = ImmutableList.copyOf(tasks);
        this.subStages = subStages;
        this.failures = failures;
    }

    @JsonProperty
    public StageId getStageId() {
        return this.stageId;
    }

    @JsonProperty
    public StageState getState() {
        return this.state;
    }

    @JsonProperty
    public URI getSelf() {
        return this.self;
    }

    @JsonProperty
    @Nullable
    public PlanFragment getPlan() {
        return this.plan;
    }

    @JsonProperty
    public List<TupleInfo> getTupleInfos() {
        return this.tupleInfos;
    }

    @JsonProperty
    public StageStats getStageStats() {
        return this.stageStats;
    }

    @JsonProperty
    public List<TaskInfo> getTasks() {
        return this.tasks;
    }

    @JsonProperty
    public List<StageInfo> getSubStages() {
        return this.subStages;
    }

    @JsonProperty
    public List<ExecutionFailureInfo> getFailures() {
        return this.failures;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("stageId", (Object)this.stageId).add("state", (Object)this.state).toString();
    }

    public static List<StageInfo> getAllStages(StageInfo stageInfo) {
        ImmutableList.Builder collector = ImmutableList.builder();
        if (stageInfo != null) {
            StageInfo.addAllStages(stageInfo, (ImmutableList.Builder<StageInfo>)collector);
        }
        return collector.build();
    }

    private static void addAllStages(StageInfo stageInfo, ImmutableList.Builder<StageInfo> collector) {
        collector.add((Object)stageInfo);
        for (StageInfo subStage : stageInfo.getSubStages()) {
            StageInfo.addAllStages(subStage, collector);
        }
    }

    public static Function<StageInfo, StageState> stageStateGetter() {
        return new Function<StageInfo, StageState>(){

            public StageState apply(StageInfo stageInfo) {
                return stageInfo.getState();
            }
        };
    }
}

