/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.google.common.base.Predicate;

public enum TaskState {
    PLANNED(false),
    RUNNING(false),
    FINISHED(true),
    CANCELED(true),
    FAILED(true);

    private final boolean doneState;

    private TaskState(boolean doneState) {
        this.doneState = doneState;
    }

    public boolean isDone() {
        return this.doneState;
    }

    public static Predicate<TaskState> inDoneState() {
        return new Predicate<TaskState>(){

            public boolean apply(TaskState state) {
                return state.isDone();
            }
        };
    }
}

