/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.guice;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.IDBI;

public class DbiProvider
implements Provider<IDBI> {
    private final Class<? extends Annotation> annotationType;
    private Injector injector;

    public DbiProvider(Class<? extends Annotation> annotationType) {
        this.annotationType = (Class)Preconditions.checkNotNull(annotationType, (Object)"annotationType is null");
    }

    @Inject
    public void setInjector(Injector injector) {
        this.injector = (Injector)Preconditions.checkNotNull((Object)injector, (Object)"injector is null");
    }

    public IDBI get() {
        Preconditions.checkState((this.injector != null ? 1 : 0) != 0, (Object)"injector was not set");
        return new DBI((DataSource)this.injector.getInstance(Key.get(DataSource.class, this.annotationType)));
    }

    public static void bindDbiToDataSource(Binder bind, Class<? extends Annotation> annotationType) {
        bind.bind(IDBI.class).annotatedWith(annotationType).toProvider((Provider)new DbiProvider(annotationType));
    }
}

