/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import java.io.File;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class DatabaseLocalStorageManagerConfig {
    private File dataDirectory = new File("var/data");
    private int tasksPerNode = 32;
    private boolean compressed = true;

    @NotNull
    public File getDataDirectory() {
        return this.dataDirectory;
    }

    @Config(value="storage-manager.data-directory")
    @ConfigDescription(value="Base directory to use for storing shard data")
    public DatabaseLocalStorageManagerConfig setDataDirectory(File dataDirectory) {
        this.dataDirectory = dataDirectory;
        return this;
    }

    @Min(value=1L)
    public int getTasksPerNode() {
        return this.tasksPerNode;
    }

    @Config(value="storage-manager.tasks-per-node")
    @ConfigDescription(value="Number of background tasks")
    public DatabaseLocalStorageManagerConfig setTasksPerNode(int tasksPerNode) {
        this.tasksPerNode = tasksPerNode;
        return this;
    }

    @Deprecated
    public boolean isCompressed() {
        return this.compressed;
    }

    @Deprecated
    @Config(value="storage-manager.compress")
    public DatabaseLocalStorageManagerConfig setCompressed(boolean compressed) {
        this.compressed = compressed;
        return this;
    }
}

