/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.ForShardManager;
import com.facebook.presto.metadata.NativeTableHandle;
import com.facebook.presto.metadata.ShardManager;
import com.facebook.presto.metadata.ShardManagerDao;
import com.facebook.presto.metadata.ShardNode;
import com.facebook.presto.metadata.TablePartition;
import com.facebook.presto.spi.PartitionKey;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.split.NativePartitionKey;
import com.facebook.presto.util.SqlUtils;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.VoidTransactionCallback;

public class DatabaseShardManager
implements ShardManager {
    private final IDBI dbi;
    private final ShardManagerDao dao;

    @Inject
    public DatabaseShardManager(@ForShardManager IDBI dbi) throws InterruptedException {
        this.dbi = dbi;
        this.dao = (ShardManagerDao)dbi.onDemand(ShardManagerDao.class);
        ShardManagerDao.Utils.createShardTablesWithRetry(this.dao);
    }

    @Override
    public void commitPartition(TableHandle tableHandle, final String partition, final List<? extends PartitionKey> partitionKeys, final Map<UUID, String> shards) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkNotNull((Object)partition, (Object)"partition is null");
        Preconditions.checkNotNull(partitionKeys, (Object)"partitionKeys is null");
        Preconditions.checkNotNull(shards, (Object)"shards is null");
        Preconditions.checkState((boolean)(tableHandle instanceof NativeTableHandle), (Object)"can only commit partitions for native tables");
        final long tableId = ((NativeTableHandle)tableHandle).getTableId();
        this.dbi.inTransaction((TransactionCallback)new VoidTransactionCallback(){

            protected void execute(Handle handle, TransactionStatus status) {
                ShardManagerDao dao = (ShardManagerDao)handle.attach(ShardManagerDao.class);
                long partitionId = dao.insertPartition(tableId, partition);
                for (PartitionKey partitionKey : partitionKeys) {
                    dao.insertPartitionKey(tableId, partition, partitionKey.getName(), partitionKey.getType().toString(), partitionKey.getValue());
                }
                for (Map.Entry entry : shards.entrySet()) {
                    long nodeId = DatabaseShardManager.this.getOrCreateNodeId((String)entry.getValue());
                    UUID shardUuid = (UUID)entry.getKey();
                    long shardId = dao.insertShard(shardUuid);
                    dao.insertShardNode(shardId, nodeId);
                    dao.insertPartitionShard(shardId, tableId, partitionId);
                }
            }
        });
    }

    @Override
    public void commitUnpartitionedTable(TableHandle tableHandle, Map<UUID, String> shards) {
        this.commitPartition(tableHandle, "<UNPARTITIONED>", (List<? extends PartitionKey>)ImmutableList.of(), shards);
    }

    @Override
    public void disassociateShard(long shardId, @Nullable String nodeIdentifier) {
        this.dao.dropShardNode(shardId, nodeIdentifier);
    }

    @Override
    public void dropShard(final long shardId) {
        this.dbi.inTransaction((TransactionCallback)new VoidTransactionCallback(){

            protected void execute(Handle handle, TransactionStatus status) {
                ShardManagerDao dao = (ShardManagerDao)handle.attach(ShardManagerDao.class);
                dao.deleteShardFromPartitionShards(shardId);
                dao.deleteShard(shardId);
            }
        });
    }

    @Override
    public Set<TablePartition> getPartitions(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkState((boolean)(tableHandle instanceof NativeTableHandle), (Object)"can only commit partitions for native tables");
        long tableId = ((NativeTableHandle)tableHandle).getTableId();
        return this.dao.getPartitions(tableId);
    }

    @Override
    public Multimap<String, ? extends PartitionKey> getAllPartitionKeys(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkState((boolean)(tableHandle instanceof NativeTableHandle), (Object)"can only commit partitions for native tables");
        long tableId = ((NativeTableHandle)tableHandle).getTableId();
        Set<NativePartitionKey> partitionKeys = this.dao.getPartitionKeys(tableId);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (NativePartitionKey partitionKey : partitionKeys) {
            builder.put((Object)partitionKey.getPartitionName(), (Object)partitionKey);
        }
        return builder.build();
    }

    @Override
    public Multimap<Long, Map.Entry<UUID, String>> getShardNodesByPartition(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkState((boolean)(tableHandle instanceof NativeTableHandle), (Object)"tableHandle not a native table");
        long tableId = ((NativeTableHandle)tableHandle).getTableId();
        ImmutableMultimap.Builder map = ImmutableMultimap.builder();
        for (ShardNode shardNode : this.dao.getShardNodes(tableId)) {
            map.put((Object)shardNode.getPartitionId(), (Object)Maps.immutableEntry((Object)shardNode.getShardUuid(), (Object)shardNode.getNodeIdentifier()));
        }
        return map.build();
    }

    @Override
    public Set<String> getTableNodes(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkState((boolean)(tableHandle instanceof NativeTableHandle), (Object)"tableHandle not a native table");
        long tableId = ((NativeTableHandle)tableHandle).getTableId();
        return ImmutableSet.copyOf(this.dao.getTableNodes(tableId));
    }

    @Override
    public Iterable<String> getAllNodesInUse() {
        return this.dao.getAllNodesInUse();
    }

    @Override
    public void dropPartition(TableHandle tableHandle, final String partitionName) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkState((boolean)(tableHandle instanceof NativeTableHandle), (Object)"can only commit partitions for native tables");
        final long tableId = ((NativeTableHandle)tableHandle).getTableId();
        this.dbi.inTransaction((TransactionCallback)new VoidTransactionCallback(){

            protected void execute(Handle handle, TransactionStatus status) throws Exception {
                ShardManagerDao dao = (ShardManagerDao)handle.attach(ShardManagerDao.class);
                List<Long> shardIds = dao.getAllShards(tableId, partitionName);
                for (Long shardId : shardIds) {
                    dao.deleteShardFromPartitionShards(shardId);
                }
                dao.dropPartitionKeys(tableId, partitionName);
                dao.dropPartition(tableId, partitionName);
            }
        });
    }

    @Override
    public Iterable<Long> getOrphanedShardIds(Optional<String> nodeIdentifier) {
        if (nodeIdentifier.isPresent()) {
            return this.dao.getOrphanedShards((String)nodeIdentifier.get());
        }
        return this.dao.getAllOrphanedShards();
    }

    @Override
    public void dropOrphanedPartitions() {
        this.dao.dropAllOrphanedPartitions();
    }

    private long getOrCreateNodeId(final String nodeIdentifier) {
        Long id = this.dao.getNodeId(nodeIdentifier);
        if (id != null) {
            return id;
        }
        SqlUtils.runIgnoringConstraintViolation(new Runnable(){

            @Override
            public void run() {
                DatabaseShardManager.this.dao.insertNode(nodeIdentifier);
            }
        });
        id = this.dao.getNodeId(nodeIdentifier);
        if (id == null) {
            throw new IllegalStateException("node does not exist after insert");
        }
        return id;
    }
}

