/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.AggregationFunctionDefinition;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.window.WindowFunction;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.gen.FunctionBinder;
import com.facebook.presto.sql.tree.Input;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class FunctionInfo {
    private final Signature signature;
    private final String description;
    private final boolean isAggregate;
    private final Type intermediateType;
    private final AggregationFunction aggregationFunction;
    private final MethodHandle scalarFunction;
    private final boolean deterministic;
    private final FunctionBinder functionBinder;
    private final boolean isWindow;
    private final Supplier<WindowFunction> windowFunction;

    public FunctionInfo(Signature signature, String description, Supplier<WindowFunction> windowFunction) {
        this.signature = signature;
        this.description = description;
        this.deterministic = true;
        this.isAggregate = false;
        this.intermediateType = null;
        this.aggregationFunction = null;
        this.scalarFunction = null;
        this.functionBinder = null;
        this.isWindow = true;
        this.windowFunction = (Supplier)Preconditions.checkNotNull(windowFunction, (Object)"windowFunction is null");
    }

    public FunctionInfo(Signature signature, String description, Type intermediateType, AggregationFunction function) {
        this.signature = signature;
        this.description = description;
        this.intermediateType = intermediateType;
        this.aggregationFunction = function;
        this.isAggregate = true;
        this.scalarFunction = null;
        this.deterministic = true;
        this.functionBinder = null;
        this.isWindow = false;
        this.windowFunction = null;
    }

    public FunctionInfo(Signature signature, String description, MethodHandle function, boolean deterministic, FunctionBinder functionBinder) {
        this.signature = signature;
        this.description = description;
        this.deterministic = deterministic;
        this.functionBinder = functionBinder;
        this.isAggregate = false;
        this.intermediateType = null;
        this.aggregationFunction = null;
        this.isWindow = false;
        this.windowFunction = null;
        this.scalarFunction = (MethodHandle)Preconditions.checkNotNull((Object)function, (Object)"function is null");
    }

    public Signature getHandle() {
        return this.signature;
    }

    public QualifiedName getName() {
        return QualifiedName.of((String)this.signature.getName(), (String[])new String[0]);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public boolean isWindow() {
        return this.isWindow;
    }

    public boolean isScalar() {
        return !this.isWindow && !this.isAggregate;
    }

    public Supplier<WindowFunction> getWindowFunction() {
        Preconditions.checkState((boolean)this.isWindow, (Object)"not a window function");
        return this.windowFunction;
    }

    public boolean isApproximate() {
        return this.signature.isApproximate();
    }

    public Type getReturnType() {
        return this.signature.getReturnType();
    }

    public List<Type> getArgumentTypes() {
        return this.signature.getArgumentTypes();
    }

    public Type getIntermediateType() {
        return this.intermediateType;
    }

    public AggregationFunctionDefinition bind(List<Input> inputs, Optional<Input> mask, Optional<Input> sampleWeight, double confidence) {
        Preconditions.checkState((boolean)this.isAggregate, (Object)"function is not an aggregate");
        return AggregationFunctionDefinition.aggregation(this.aggregationFunction, inputs, mask, sampleWeight, confidence);
    }

    public AggregationFunction getAggregationFunction() {
        Preconditions.checkState((this.aggregationFunction != null ? 1 : 0) != 0, (Object)"not an aggregation function");
        return this.aggregationFunction;
    }

    public MethodHandle getScalarFunction() {
        Preconditions.checkState((this.scalarFunction != null ? 1 : 0) != 0, (Object)"not a scalar function");
        return this.scalarFunction;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public FunctionBinder getFunctionBinder() {
        return this.functionBinder;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionInfo other = (FunctionInfo)obj;
        return Objects.equal((Object)this.signature, (Object)other.signature) && Objects.equal((Object)this.isAggregate, (Object)other.isAggregate) && Objects.equal((Object)this.isWindow, (Object)other.isWindow);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.signature, this.isAggregate, this.isWindow});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("signature", (Object)this.signature).add("isAggregate", this.isAggregate).add("isWindow", this.isWindow).toString();
    }

    public static Function<FunctionInfo, QualifiedName> nameGetter() {
        return new Function<FunctionInfo, QualifiedName>(){

            public QualifiedName apply(FunctionInfo input) {
                return input.getName();
            }
        };
    }

    public static Function<FunctionInfo, Signature> handleGetter() {
        return new Function<FunctionInfo, Signature>(){

            public Signature apply(FunctionInfo input) {
                return input.getHandle();
            }
        };
    }

    public static Predicate<FunctionInfo> isAggregationPredicate() {
        return new Predicate<FunctionInfo>(){

            public boolean apply(FunctionInfo functionInfo) {
                return functionInfo.isAggregate();
            }
        };
    }
}

