/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.ApproximateAverageAggregations;
import com.facebook.presto.operator.aggregation.ApproximateCountAggregation;
import com.facebook.presto.operator.aggregation.ApproximateCountColumnAggregations;
import com.facebook.presto.operator.aggregation.ApproximateCountDistinctAggregations;
import com.facebook.presto.operator.aggregation.ApproximateDoubleSumAggregation;
import com.facebook.presto.operator.aggregation.ApproximateLongSumAggregation;
import com.facebook.presto.operator.aggregation.ApproximatePercentileAggregations;
import com.facebook.presto.operator.aggregation.ApproximatePercentileWeightedAggregations;
import com.facebook.presto.operator.aggregation.AverageAggregations;
import com.facebook.presto.operator.aggregation.BooleanMaxAggregation;
import com.facebook.presto.operator.aggregation.BooleanMinAggregation;
import com.facebook.presto.operator.aggregation.CountAggregation;
import com.facebook.presto.operator.aggregation.CountColumnAggregations;
import com.facebook.presto.operator.aggregation.CountIfAggregation;
import com.facebook.presto.operator.aggregation.DoubleMaxAggregation;
import com.facebook.presto.operator.aggregation.DoubleMinAggregation;
import com.facebook.presto.operator.aggregation.DoubleSumAggregation;
import com.facebook.presto.operator.aggregation.LongMaxAggregation;
import com.facebook.presto.operator.aggregation.LongMinAggregation;
import com.facebook.presto.operator.aggregation.LongSumAggregation;
import com.facebook.presto.operator.aggregation.VarBinaryMaxAggregation;
import com.facebook.presto.operator.aggregation.VarBinaryMinAggregation;
import com.facebook.presto.operator.aggregation.VarianceAggregations;
import com.facebook.presto.operator.scalar.ColorFunctions;
import com.facebook.presto.operator.scalar.JsonFunctions;
import com.facebook.presto.operator.scalar.MathFunctions;
import com.facebook.presto.operator.scalar.RegexpFunctions;
import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.operator.scalar.StringFunctions;
import com.facebook.presto.operator.scalar.UnixTimeFunctions;
import com.facebook.presto.operator.scalar.UrlFunctions;
import com.facebook.presto.operator.window.CumulativeDistributionFunction;
import com.facebook.presto.operator.window.DenseRankFunction;
import com.facebook.presto.operator.window.PercentRankFunction;
import com.facebook.presto.operator.window.RankFunction;
import com.facebook.presto.operator.window.RowNumberFunction;
import com.facebook.presto.operator.window.WindowFunction;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.gen.FunctionBinder;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.util.IterableTransformer;
import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FunctionRegistry {
    private volatile FunctionMap functions = new FunctionMap();

    public FunctionRegistry() {
        List<FunctionInfo> functions = new FunctionListBuilder().window("row_number", Type.BIGINT, (List<Type>)ImmutableList.of(), FunctionRegistry.supplier(RowNumberFunction.class)).window("rank", Type.BIGINT, (List<Type>)ImmutableList.of(), FunctionRegistry.supplier(RankFunction.class)).window("dense_rank", Type.BIGINT, (List<Type>)ImmutableList.of(), FunctionRegistry.supplier(DenseRankFunction.class)).window("percent_rank", Type.DOUBLE, (List<Type>)ImmutableList.of(), FunctionRegistry.supplier(PercentRankFunction.class)).window("cume_dist", Type.DOUBLE, (List<Type>)ImmutableList.of(), FunctionRegistry.supplier(CumulativeDistributionFunction.class)).aggregate("count", Type.BIGINT, (List<Type>)ImmutableList.of(), Type.BIGINT, CountAggregation.COUNT).aggregate("count", Type.BIGINT, (List<Type>)ImmutableList.of((Object)((Object)Type.BOOLEAN)), Type.BIGINT, CountColumnAggregations.COUNT_BOOLEAN_COLUMN).aggregate("count", Type.BIGINT, (List<Type>)ImmutableList.of((Object)((Object)Type.BIGINT)), Type.BIGINT, CountColumnAggregations.COUNT_LONG_COLUMN).aggregate("count", Type.BIGINT, (List<Type>)ImmutableList.of((Object)((Object)Type.DOUBLE)), Type.BIGINT, CountColumnAggregations.COUNT_DOUBLE_COLUMN).aggregate("count", Type.BIGINT, (List<Type>)ImmutableList.of((Object)((Object)Type.VARCHAR)), Type.BIGINT, CountColumnAggregations.COUNT_STRING_COLUMN).aggregate("count_if", Type.BIGINT, (List<Type>)ImmutableList.of((Object)((Object)Type.BOOLEAN)), Type.BIGINT, CountIfAggregation.COUNT_IF).aggregate("sum", Type.BIGINT, (List<Type>)ImmutableList.of((Object)((Object)Type.BIGINT)), Type.BIGINT, LongSumAggregation.LONG_SUM).aggregate("sum", Type.DOUBLE, (List<Type>)ImmutableList.of((Object)((Object)Type.DOUBLE)), Type.DOUBLE, DoubleSumAggregation.DOUBLE_SUM).aggregate("avg", Type.DOUBLE, (List<Type>)ImmutableList.of((Object)((Object)Type.DOUBLE)), Type.VARCHAR, AverageAggregations.DOUBLE_AVERAGE).aggregate("avg", Type.DOUBLE, (List<Type>)ImmutableList.of((Object)((Object)Type.BIGINT)), Type.VARCHAR, AverageAggregations.LONG_AVERAGE).aggregate("max", Type.BOOLEAN, (List<Type>)ImmutableList.of((Object)((Object)Type.BOOLEAN)), Type.BOOLEAN, BooleanMaxAggregation.BOOLEAN_MAX).aggregate("max", Type.BIGINT, (List<Type>)ImmutableList.of((Object)((Object)Type.BIGINT)), Type.BIGINT, LongMaxAggregation.LONG_MAX).aggregate("max", Type.DOUBLE, (List<Type>)ImmutableList.of((Object)((Object)Type.DOUBLE)), Type.DOUBLE, DoubleMaxAggregation.DOUBLE_MAX).aggregate("max", Type.VARCHAR, (List<Type>)ImmutableList.of((Object)((Object)Type.VARCHAR)), Type.VARCHAR, VarBinaryMaxAggregation.VAR_BINARY_MAX).aggregate("min", Type.BOOLEAN, (List<Type>)ImmutableList.of((Object)((Object)Type.BOOLEAN)), Type.BOOLEAN, BooleanMinAggregation.BOOLEAN_MIN).aggregate("min", Type.BIGINT, (List<Type>)ImmutableList.of((Object)((Object)Type.BIGINT)), Type.BIGINT, LongMinAggregation.LONG_MIN).aggregate("min", Type.DOUBLE, (List<Type>)ImmutableList.of((Object)((Object)Type.DOUBLE)), Type.DOUBLE, DoubleMinAggregation.DOUBLE_MIN).aggregate("min", Type.VARCHAR, (List<Type>)ImmutableList.of((Object)((Object)Type.VARCHAR)), Type.VARCHAR, VarBinaryMinAggregation.VAR_BINARY_MIN).aggregate("var_pop", Type.DOUBLE, (List<Type>)ImmutableList.of((Object)((Object)Type.DOUBLE)), Type.VARCHAR, VarianceAggregations.DOUBLE_VARIANCE_POP_INSTANCE).aggregate("var_pop", Type.DOUBLE, (List<Type>)ImmutableList.of((Object)((Object)Type.BIGINT)), Type.VARCHAR, VarianceAggregations.LONG_VARIANCE_POP_INSTANCE).aggregate("var_samp", Type.DOUBLE, (List<Type>)ImmutableList.of((Object)((Object)Type.DOUBLE)), Type.VARCHAR, VarianceAggregations.DOUBLE_VARIANCE_INSTANCE).aggregate("var_samp", Type.DOUBLE, (List<Type>)ImmutableList.of((Object)((Object)Type.BIGINT)), Type.VARCHAR, VarianceAggregations.LONG_VARIANCE_INSTANCE).aggregate("variance", Type.DOUBLE, (List<Type>)ImmutableList.of((Object)((Object)Type.DOUBLE)), Type.VARCHAR, VarianceAggregations.DOUBLE_VARIANCE_INSTANCE).aggregate("variance", Type.DOUBLE, (List<Type>)ImmutableList.of((Object)((Object)Type.BIGINT)), Type.VARCHAR, VarianceAggregations.LONG_VARIANCE_INSTANCE).aggregate("stddev_pop", Type.DOUBLE, (List<Type>)ImmutableList.of((Object)((Object)Type.DOUBLE)), Type.VARCHAR, VarianceAggregations.DOUBLE_STDDEV_POP_INSTANCE).aggregate("stddev_pop", Type.DOUBLE, (List<Type>)ImmutableList.of((Object)((Object)Type.BIGINT)), Type.VARCHAR, VarianceAggregations.LONG_STDDEV_POP_INSTANCE).aggregate("stddev_samp", Type.DOUBLE, (List<Type>)ImmutableList.of((Object)((Object)Type.DOUBLE)), Type.VARCHAR, VarianceAggregations.DOUBLE_STDDEV_INSTANCE).aggregate("stddev_samp", Type.DOUBLE, (List<Type>)ImmutableList.of((Object)((Object)Type.BIGINT)), Type.VARCHAR, VarianceAggregations.LONG_STDDEV_INSTANCE).aggregate("stddev", Type.DOUBLE, (List<Type>)ImmutableList.of((Object)((Object)Type.DOUBLE)), Type.VARCHAR, VarianceAggregations.DOUBLE_STDDEV_INSTANCE).aggregate("stddev", Type.DOUBLE, (List<Type>)ImmutableList.of((Object)((Object)Type.BIGINT)), Type.VARCHAR, VarianceAggregations.LONG_STDDEV_INSTANCE).aggregate("approx_distinct", Type.BIGINT, (List<Type>)ImmutableList.of((Object)((Object)Type.BOOLEAN)), Type.VARCHAR, ApproximateCountDistinctAggregations.LONG_APPROXIMATE_COUNT_DISTINCT_AGGREGATIONS).aggregate("approx_distinct", Type.BIGINT, (List<Type>)ImmutableList.of((Object)((Object)Type.BIGINT)), Type.VARCHAR, ApproximateCountDistinctAggregations.LONG_APPROXIMATE_COUNT_DISTINCT_AGGREGATIONS).aggregate("approx_distinct", Type.BIGINT, (List<Type>)ImmutableList.of((Object)((Object)Type.DOUBLE)), Type.VARCHAR, ApproximateCountDistinctAggregations.DOUBLE_APPROXIMATE_COUNT_DISTINCT_AGGREGATIONS).aggregate("approx_distinct", Type.BIGINT, (List<Type>)ImmutableList.of((Object)((Object)Type.VARCHAR)), Type.VARCHAR, ApproximateCountDistinctAggregations.VARBINARY_APPROXIMATE_COUNT_DISTINCT_AGGREGATIONS).aggregate("approx_percentile", Type.BIGINT, (List<Type>)ImmutableList.of((Object)((Object)Type.BIGINT), (Object)((Object)Type.DOUBLE)), Type.VARCHAR, ApproximatePercentileAggregations.LONG_APPROXIMATE_PERCENTILE_AGGREGATION).aggregate("approx_percentile", Type.BIGINT, (List<Type>)ImmutableList.of((Object)((Object)Type.BIGINT), (Object)((Object)Type.BIGINT), (Object)((Object)Type.DOUBLE)), Type.VARCHAR, ApproximatePercentileWeightedAggregations.LONG_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION).aggregate("approx_percentile", Type.DOUBLE, (List<Type>)ImmutableList.of((Object)((Object)Type.DOUBLE), (Object)((Object)Type.DOUBLE)), Type.VARCHAR, ApproximatePercentileAggregations.DOUBLE_APPROXIMATE_PERCENTILE_AGGREGATION).aggregate("approx_percentile", Type.DOUBLE, (List<Type>)ImmutableList.of((Object)((Object)Type.DOUBLE), (Object)((Object)Type.BIGINT), (Object)((Object)Type.DOUBLE)), Type.VARCHAR, ApproximatePercentileWeightedAggregations.DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION).aggregate("approx_avg", Type.VARCHAR, (List<Type>)ImmutableList.of((Object)((Object)Type.BIGINT)), Type.VARCHAR, ApproximateAverageAggregations.LONG_APPROXIMATE_AVERAGE_AGGREGATION).aggregate("approx_avg", Type.VARCHAR, (List<Type>)ImmutableList.of((Object)((Object)Type.DOUBLE)), Type.VARCHAR, ApproximateAverageAggregations.DOUBLE_APPROXIMATE_AVERAGE_AGGREGATION).approximateAggregate("avg", Type.VARCHAR, (List<Type>)ImmutableList.of((Object)((Object)Type.BIGINT)), Type.VARCHAR, ApproximateAverageAggregations.LONG_APPROXIMATE_AVERAGE_AGGREGATION).approximateAggregate("avg", Type.VARCHAR, (List<Type>)ImmutableList.of((Object)((Object)Type.DOUBLE)), Type.VARCHAR, ApproximateAverageAggregations.DOUBLE_APPROXIMATE_AVERAGE_AGGREGATION).approximateAggregate("sum", Type.VARCHAR, (List<Type>)ImmutableList.of((Object)((Object)Type.BIGINT)), Type.VARCHAR, ApproximateLongSumAggregation.LONG_APPROXIMATE_SUM_AGGREGATION).approximateAggregate("sum", Type.VARCHAR, (List<Type>)ImmutableList.of((Object)((Object)Type.DOUBLE)), Type.VARCHAR, ApproximateDoubleSumAggregation.DOUBLE_APPROXIMATE_SUM_AGGREGATION).approximateAggregate("count", Type.VARCHAR, (List<Type>)ImmutableList.of(), Type.VARCHAR, ApproximateCountAggregation.APPROXIMATE_COUNT_AGGREGATION).approximateAggregate("count", Type.VARCHAR, (List<Type>)ImmutableList.of((Object)((Object)Type.BOOLEAN)), Type.VARCHAR, ApproximateCountColumnAggregations.BOOLEAN_APPROXIMATE_COUNT_AGGREGATION).approximateAggregate("count", Type.VARCHAR, (List<Type>)ImmutableList.of((Object)((Object)Type.BIGINT)), Type.VARCHAR, ApproximateCountColumnAggregations.LONG_APPROXIMATE_COUNT_AGGREGATION).approximateAggregate("count", Type.VARCHAR, (List<Type>)ImmutableList.of((Object)((Object)Type.DOUBLE)), Type.VARCHAR, ApproximateCountColumnAggregations.DOUBLE_APPROXIMATE_COUNT_AGGREGATION).approximateAggregate("count", Type.VARCHAR, (List<Type>)ImmutableList.of((Object)((Object)Type.VARCHAR)), Type.VARCHAR, ApproximateCountColumnAggregations.VARBINARY_APPROXIMATE_COUNT_AGGREGATION).scalar(StringFunctions.class).scalar(RegexpFunctions.class).scalar(UrlFunctions.class).scalar(MathFunctions.class).scalar(UnixTimeFunctions.class).scalar(JsonFunctions.class).scalar(ColorFunctions.class).build();
        this.addFunctions(functions);
    }

    public final synchronized void addFunctions(List<FunctionInfo> functions) {
        for (FunctionInfo function : functions) {
            Preconditions.checkArgument((this.functions.get(function.getHandle()) == null ? 1 : 0) != 0, (String)"Function already registered: %s", (Object[])new Object[]{function.getHandle()});
        }
        this.functions = new FunctionMap(this.functions, functions);
    }

    public List<FunctionInfo> list() {
        return this.functions.list();
    }

    public boolean isAggregationFunction(QualifiedName name) {
        return Iterables.any(this.functions.get(name), FunctionInfo.isAggregationPredicate());
    }

    public FunctionInfo get(QualifiedName name, List<Type> parameterTypes, final boolean approximate) {
        List<FunctionInfo> candidates = IterableTransformer.on(this.functions.get(name)).select(new Predicate<FunctionInfo>(){

            public boolean apply(FunctionInfo input) {
                return input.isScalar() || input.isApproximate() == approximate;
            }
        }).list();
        for (FunctionInfo functionInfo : candidates) {
            if (!functionInfo.getArgumentTypes().equals(parameterTypes)) continue;
            return functionInfo;
        }
        for (FunctionInfo functionInfo : candidates) {
            if (!FunctionRegistry.canCoerce(parameterTypes, functionInfo)) continue;
            return functionInfo;
        }
        ArrayList<String> expectedParameters = new ArrayList<String>();
        for (FunctionInfo functionInfo : candidates) {
            expectedParameters.add(String.format("%s(%s)", name, Joiner.on((String)", ").join(functionInfo.getArgumentTypes())));
        }
        String parameters = Joiner.on((String)", ").join(parameterTypes);
        String message = String.format("Function %s not registered", name);
        if (!expectedParameters.isEmpty()) {
            String expected = Joiner.on((String)", ").join(expectedParameters);
            message = String.format("Unexpected parameters (%s) for function %s. Expected: %s", parameters, name, expected);
        }
        throw new PrestoException(StandardErrorCode.FUNCTION_NOT_FOUND.toErrorCode(), message);
    }

    private static boolean canCoerce(List<Type> parameterTypes, FunctionInfo functionInfo) {
        List<Type> functionArguments = functionInfo.getArgumentTypes();
        if (parameterTypes.size() != functionArguments.size()) {
            return false;
        }
        for (int i = 0; i < functionArguments.size(); ++i) {
            Type parameterType;
            Type functionArgument = functionArguments.get(i);
            if (functionArgument == (parameterType = parameterTypes.get(i)) || functionArgument == Type.DOUBLE && parameterType == Type.BIGINT) continue;
            return false;
        }
        return true;
    }

    public FunctionInfo get(Signature signature) {
        return this.functions.get(signature);
    }

    private static List<Type> types(MethodHandle handle) {
        ImmutableList.Builder types = ImmutableList.builder();
        for (Class<?> parameter : FunctionRegistry.getParameterTypes(handle.type().parameterArray())) {
            types.add((Object)FunctionRegistry.type(parameter));
        }
        return types.build();
    }

    private static List<Class<?>> getParameterTypes(Class<?> ... types) {
        ImmutableList parameterTypes = ImmutableList.copyOf((Object[])types);
        if (!parameterTypes.isEmpty() && parameterTypes.get(0) == Session.class) {
            parameterTypes = parameterTypes.subList(1, parameterTypes.size());
        }
        return parameterTypes;
    }

    private static Type type(Class<?> clazz) {
        if ((clazz = Primitives.unwrap(clazz)) == Long.TYPE) {
            return Type.BIGINT;
        }
        if (clazz == Double.TYPE) {
            return Type.DOUBLE;
        }
        if (clazz == Slice.class) {
            return Type.VARCHAR;
        }
        if (clazz == Boolean.TYPE) {
            return Type.BOOLEAN;
        }
        throw new IllegalArgumentException("Unhandled type: " + clazz.getName());
    }

    public static Supplier<WindowFunction> supplier(final Class<? extends WindowFunction> clazz) {
        return new Supplier<WindowFunction>(){

            public WindowFunction get() {
                try {
                    return (WindowFunction)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        };
    }

    private static class FunctionMap {
        private final Multimap<QualifiedName, FunctionInfo> byName;
        private final Map<Signature, FunctionInfo> bySignature;

        public FunctionMap() {
            this.byName = ImmutableListMultimap.of();
            this.bySignature = ImmutableMap.of();
        }

        public FunctionMap(FunctionMap map, Iterable<FunctionInfo> functions) {
            ImmutableListMultimap byName = ImmutableListMultimap.builder().putAll(map.byName).putAll((Multimap)Multimaps.index(functions, FunctionInfo.nameGetter())).build();
            ImmutableMap bySignature = ImmutableMap.builder().putAll(map.bySignature).putAll((Map)Maps.uniqueIndex(functions, FunctionInfo.handleGetter())).build();
            for (Map.Entry entry : byName.asMap().entrySet()) {
                Collection infos = (Collection)entry.getValue();
                Preconditions.checkState((Iterables.all((Iterable)infos, FunctionInfo.isAggregationPredicate()) || !Iterables.any((Iterable)infos, FunctionInfo.isAggregationPredicate()) ? 1 : 0) != 0, (String)"'%s' is both an aggregation and a scalar function", (Object[])new Object[]{entry.getKey()});
            }
            this.byName = byName;
            this.bySignature = bySignature;
        }

        public List<FunctionInfo> list() {
            return ImmutableList.copyOf((Collection)this.byName.values());
        }

        public Collection<FunctionInfo> get(QualifiedName name) {
            return this.byName.get((Object)name);
        }

        public FunctionInfo get(Signature signature) {
            return this.bySignature.get(signature);
        }
    }

    public static class FunctionListBuilder {
        private final List<FunctionInfo> functions = new ArrayList<FunctionInfo>();
        private static final Set<Class<?>> SUPPORTED_TYPES = ImmutableSet.of(Long.TYPE, Double.TYPE, Slice.class, Boolean.TYPE);

        public FunctionListBuilder window(String name, Type returnType, List<Type> argumentTypes, Supplier<WindowFunction> function) {
            name = name.toLowerCase();
            String description = FunctionListBuilder.getDescription(function.getClass());
            this.functions.add(new FunctionInfo(new Signature(name, returnType, argumentTypes, false), description, function));
            return this;
        }

        public FunctionListBuilder approximateAggregate(String name, Type returnType, List<Type> argumentTypes, Type intermediateType, AggregationFunction function) {
            return this.aggregate(name, returnType, argumentTypes, true, intermediateType, function);
        }

        public FunctionListBuilder aggregate(String name, Type returnType, List<Type> argumentTypes, Type intermediateType, AggregationFunction function) {
            return this.aggregate(name, returnType, argumentTypes, false, intermediateType, function);
        }

        private FunctionListBuilder aggregate(String name, Type returnType, List<Type> argumentTypes, boolean approximate, Type intermediateType, AggregationFunction function) {
            name = name.toLowerCase();
            String description = FunctionListBuilder.getDescription(function.getClass());
            this.functions.add(new FunctionInfo(new Signature(name, returnType, argumentTypes, approximate), description, intermediateType, function));
            return this;
        }

        public FunctionListBuilder scalar(String name, MethodHandle function, boolean deterministic, FunctionBinder functionBinder, String description) {
            name = name.toLowerCase();
            Type returnType = FunctionRegistry.type((Class)function.type().returnType());
            List argumentTypes = FunctionRegistry.types(function);
            this.functions.add(new FunctionInfo(new Signature(name, returnType, argumentTypes, false), description, function, deterministic, functionBinder));
            return this;
        }

        public FunctionListBuilder scalar(Class<?> clazz) {
            try {
                boolean foundOne = false;
                for (Method method : clazz.getMethods()) {
                    ScalarFunction scalarFunction = method.getAnnotation(ScalarFunction.class);
                    if (scalarFunction == null) continue;
                    FunctionListBuilder.checkValidMethod(method);
                    MethodHandle methodHandle = MethodHandles.lookup().unreflect(method);
                    String name = scalarFunction.value();
                    if (name.isEmpty()) {
                        name = FunctionListBuilder.camelToSnake(method.getName());
                    }
                    String description = FunctionListBuilder.getDescription(method);
                    FunctionBinder functionBinder = this.createFunctionBinder(method, scalarFunction);
                    this.scalar(name, methodHandle, scalarFunction.deterministic(), functionBinder, description);
                    for (String alias : scalarFunction.alias()) {
                        this.scalar(alias, methodHandle, scalarFunction.deterministic(), functionBinder, description);
                    }
                    foundOne = true;
                }
                Preconditions.checkArgument((boolean)foundOne, (String)"Expected class %s to contain at least one method annotated with @%s", (Object[])new Object[]{clazz.getName(), ScalarFunction.class.getSimpleName()});
            }
            catch (IllegalAccessException e) {
                throw Throwables.propagate((Throwable)e);
            }
            return this;
        }

        private FunctionBinder createFunctionBinder(Method method, ScalarFunction scalarFunction) {
            Class<? extends FunctionBinder> functionBinderClass = scalarFunction.functionBinder();
            try {
                Constructor<? extends FunctionBinder> constructor = functionBinderClass.getConstructor(MethodHandle.class, Boolean.TYPE);
                return constructor.newInstance(MethodHandles.lookup().unreflect(method), method.isAnnotationPresent(Nullable.class));
            }
            catch (ReflectiveOperationException | RuntimeException ignored) {
                try {
                    return functionBinderClass.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unable to create function binder " + functionBinderClass.getName() + " for function " + method);
                }
            }
        }

        private static String getDescription(AnnotatedElement annotatedElement) {
            Description description = annotatedElement.getAnnotation(Description.class);
            return description == null ? null : description.value();
        }

        private static String camelToSnake(String name) {
            return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
        }

        private static void checkValidMethod(Method method) {
            String message = "@ScalarFunction method %s is not valid: ";
            Preconditions.checkArgument((boolean)Modifier.isStatic(method.getModifiers()), (String)(message + "must be static"), (Object[])new Object[]{method});
            Preconditions.checkArgument((boolean)SUPPORTED_TYPES.contains(Primitives.unwrap(method.getReturnType())), (String)(message + "return type not supported"), (Object[])new Object[]{method});
            if (method.getAnnotation(Nullable.class) != null) {
                Preconditions.checkArgument((!method.getReturnType().isPrimitive() ? 1 : 0) != 0, (String)(message + "annotated with @Nullable but has primitive return type"), (Object[])new Object[]{method});
            } else {
                Preconditions.checkArgument((!Primitives.isWrapperType(method.getReturnType()) ? 1 : 0) != 0, (String)"not annotated with @Nullable but has boxed primitive return type", (Object[])new Object[]{method});
            }
            for (Class type : FunctionRegistry.getParameterTypes(method.getParameterTypes())) {
                Preconditions.checkArgument((boolean)SUPPORTED_TYPES.contains(type), (String)(message + "parameter type [%s] not supported"), (Object[])new Object[]{method, type.getName()});
            }
        }

        public List<FunctionInfo> build() {
            return ImmutableList.copyOf(this.functions);
        }
    }
}

