/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockIterable;
import com.facebook.presto.block.BlockIterables;
import com.facebook.presto.block.BlockUtils;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InternalTable {
    private final Map<String, BlockIterable> columns;

    public InternalTable(Map<String, BlockIterable> columns) {
        this.columns = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(columns, (Object)"columns is null")));
    }

    public Set<String> getColumnNames() {
        return this.columns.keySet();
    }

    public BlockIterable getColumn(String columnName) {
        return this.columns.get(columnName);
    }

    public List<BlockIterable> getColumns(List<String> columnNames) {
        ImmutableList.Builder columns = ImmutableList.builder();
        for (String columnName : columnNames) {
            columns.add((Object)this.getColumn(columnName));
        }
        return columns.build();
    }

    public static Builder builder(ColumnMetadata ... columns) {
        return InternalTable.builder((List<ColumnMetadata>)ImmutableList.copyOf((Object[])columns));
    }

    public static Builder builder(List<ColumnMetadata> columns) {
        ImmutableList.Builder names = ImmutableList.builder();
        ImmutableList.Builder tupleInfos = ImmutableList.builder();
        for (ColumnMetadata column : columns) {
            names.add((Object)column.getName());
            TupleInfo.Type type = TupleInfo.Type.fromColumnType(column.getType());
            tupleInfos.add((Object)new TupleInfo(type));
        }
        return new Builder((List<TupleInfo>)tupleInfos.build(), (List<String>)names.build());
    }

    public static class Builder {
        private final List<TupleInfo> tupleInfos;
        private final List<String> columnNames;
        private final List<List<Block>> columns;
        private PageBuilder pageBuilder;

        public Builder(List<TupleInfo> tupleInfos, List<String> columnNames) {
            this.tupleInfos = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(tupleInfos, (Object)"tupleInfos is null")));
            this.columnNames = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(columnNames, (Object)"columnNames is null")));
            Preconditions.checkArgument((columnNames.size() == tupleInfos.size() ? 1 : 0) != 0, (String)"Column name count does not match tuple type count: columnNames=%s, tupleInfos=%s", (Object[])new Object[]{columnNames, tupleInfos.size()});
            this.columns = new ArrayList<List<Block>>();
            for (int i = 0; i < tupleInfos.size(); ++i) {
                this.columns.add(new ArrayList());
            }
            this.pageBuilder = new PageBuilder(tupleInfos);
        }

        public List<TupleInfo> getTupleInfos() {
            return this.tupleInfos;
        }

        public Builder add(Object ... values) {
            for (int i = 0; i < this.tupleInfos.size(); ++i) {
                this.pageBuilder.getBlockBuilder(i).appendObject(values[i]);
            }
            if (this.pageBuilder.isFull()) {
                this.flushPage();
                this.pageBuilder.reset();
            }
            return this;
        }

        public InternalTable build() {
            this.flushPage();
            ImmutableMap.Builder data = ImmutableMap.builder();
            for (int i = 0; i < this.columns.size(); ++i) {
                List<Block> column = this.columns.get(i);
                data.put((Object)this.columnNames.get(i), (Object)(column.isEmpty() ? BlockUtils.emptyBlockIterable() : BlockIterables.createBlockIterable(column)));
            }
            return new InternalTable((Map<String, BlockIterable>)data.build());
        }

        private void flushPage() {
            if (!this.pageBuilder.isEmpty()) {
                Page page = this.pageBuilder.build();
                for (int i = 0; i < this.tupleInfos.size(); ++i) {
                    this.columns.get(i).add(page.getBlock(i));
                }
            }
        }
    }
}

