/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.ForMetadata;
import com.facebook.presto.metadata.MetadataDao;
import com.facebook.presto.metadata.MetadataDaoUtils;
import com.facebook.presto.metadata.NativeColumnHandle;
import com.facebook.presto.metadata.NativeConnectorId;
import com.facebook.presto.metadata.NativeOutputTableHandle;
import com.facebook.presto.metadata.NativeTableHandle;
import com.facebook.presto.metadata.ShardManager;
import com.facebook.presto.metadata.Table;
import com.facebook.presto.metadata.TableColumn;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.OutputTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.util.SqlUtils;
import com.facebook.presto.util.Types;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.VoidTransactionCallback;

public class NativeMetadata
implements ConnectorMetadata {
    private final IDBI dbi;
    private final MetadataDao dao;
    private final ShardManager shardManager;
    private final String connectorId;

    @Inject
    public NativeMetadata(NativeConnectorId connectorId, @ForMetadata IDBI dbi, ShardManager shardManager) {
        Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        this.connectorId = connectorId.toString();
        this.dbi = (IDBI)Preconditions.checkNotNull((Object)dbi, (Object)"dbi is null");
        this.dao = (MetadataDao)dbi.onDemand(MetadataDao.class);
        this.shardManager = (ShardManager)Preconditions.checkNotNull((Object)shardManager, (Object)"shardManager is null");
        MetadataDaoUtils.createMetadataTablesWithRetry(this.dao);
    }

    public boolean canHandle(TableHandle tableHandle) {
        return tableHandle instanceof NativeTableHandle;
    }

    public List<String> listSchemaNames() {
        return this.dao.listSchemaNames(this.connectorId);
    }

    public TableHandle getTableHandle(SchemaTableName tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        Table table = this.dao.getTableInformation(this.connectorId, tableName.getSchemaName(), tableName.getTableName());
        if (table == null) {
            return null;
        }
        Long columnId = this.dao.getColumnId(table.getTableId(), "$sample_weight");
        NativeColumnHandle sampleWeightColumnHandle = null;
        if (columnId != null) {
            sampleWeightColumnHandle = new NativeColumnHandle("$sample_weight", columnId);
        }
        return new NativeTableHandle(tableName.getSchemaName(), tableName.getTableName(), table.getTableId(), sampleWeightColumnHandle);
    }

    public ConnectorTableMetadata getTableMetadata(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof NativeTableHandle), (Object)"tableHandle is not an instance of NativeTableHandle");
        NativeTableHandle nativeTableHandle = (NativeTableHandle)tableHandle;
        SchemaTableName tableName = this.getTableName(tableHandle);
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (String)"Table %s does not exist", (Object[])new Object[]{tableName});
        ImmutableList columns = this.dao.getTableColumnMetaData(nativeTableHandle.getTableId());
        columns = ImmutableList.copyOf((Iterable)Iterables.filter(columns, (Predicate)new Predicate<ColumnMetadata>(){

            public boolean apply(ColumnMetadata input) {
                return !input.getName().equals("$sample_weight");
            }
        }));
        Preconditions.checkArgument((!columns.isEmpty() ? 1 : 0) != 0, (String)"Table %s does not have any columns", (Object[])new Object[]{tableName});
        if (columns.isEmpty()) {
            return null;
        }
        return new ConnectorTableMetadata(tableName, (List)columns);
    }

    public List<SchemaTableName> listTables(@Nullable String schemaNameOrNull) {
        return this.dao.listTables(this.connectorId, schemaNameOrNull);
    }

    public Map<String, ColumnHandle> getColumnHandles(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof NativeTableHandle), (Object)"tableHandle is not an instance of NativeTableHandle");
        NativeTableHandle nativeTableHandle = (NativeTableHandle)tableHandle;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TableColumn tableColumn : this.dao.listTableColumns(nativeTableHandle.getTableId())) {
            if (tableColumn.getColumnName().equals("$sample_weight")) continue;
            builder.put((Object)tableColumn.getColumnName(), (Object)new NativeColumnHandle(tableColumn.getColumnName(), tableColumn.getColumnId()));
        }
        return builder.build();
    }

    public ColumnHandle getColumnHandle(TableHandle tableHandle, String columnName) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof NativeTableHandle), (Object)"tableHandle is not an instance of NativeTableHandle");
        NativeTableHandle nativeTableHandle = (NativeTableHandle)tableHandle;
        Long columnId = this.dao.getColumnId(nativeTableHandle.getTableId(), columnName);
        if (columnId == null) {
            return null;
        }
        return new NativeColumnHandle(columnName, columnId);
    }

    public ColumnHandle getSampleWeightColumnHandle(TableHandle tableHandle) {
        Preconditions.checkArgument((boolean)(tableHandle instanceof NativeTableHandle), (Object)"tableHandle is not an instance of NativeTableHandle");
        return ((NativeTableHandle)tableHandle).getSampleWeightColumnHandle();
    }

    public boolean canCreateSampledTables() {
        return true;
    }

    public ColumnMetadata getColumnMetadata(TableHandle tableHandle, ColumnHandle columnHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkNotNull((Object)columnHandle, (Object)"columnHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof NativeTableHandle), (Object)"tableHandle is not an instance of NativeTableHandle");
        Preconditions.checkArgument((boolean)(columnHandle instanceof NativeColumnHandle), (Object)"columnHandle is not an instance of NativeColumnHandle");
        long tableId = ((NativeTableHandle)tableHandle).getTableId();
        long columnId = ((NativeColumnHandle)columnHandle).getColumnId();
        ColumnMetadata columnMetadata = this.dao.getColumnMetadata(tableId, columnId);
        Preconditions.checkState((columnMetadata != null ? 1 : 0) != 0, (String)"no column with id %s exists", (Object[])new Object[]{columnId});
        return columnMetadata;
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(SchemaTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        ImmutableListMultimap.Builder columns = ImmutableListMultimap.builder();
        for (TableColumn tableColumn : this.dao.listTableColumns(this.connectorId, prefix.getSchemaName(), prefix.getTableName())) {
            if (tableColumn.getColumnName().equals("$sample_weight")) continue;
            ColumnMetadata columnMetadata = new ColumnMetadata(tableColumn.getColumnName(), tableColumn.getDataType().toColumnType(), tableColumn.getOrdinalPosition(), false);
            columns.put((Object)tableColumn.getTable().asSchemaTableName(), (Object)columnMetadata);
        }
        return Multimaps.asMap((ListMultimap)columns.build());
    }

    private SchemaTableName getTableName(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof NativeTableHandle), (Object)"tableHandle is not an instance of NativeTableHandle");
        long tableId = ((NativeTableHandle)tableHandle).getTableId();
        SchemaTableName tableName = this.dao.getTableName(tableId).asSchemaTableName();
        Preconditions.checkState((tableName != null ? 1 : 0) != 0, (String)"no table with id %s exists", (Object[])new Object[]{tableId});
        return tableName;
    }

    public TableHandle createTable(final ConnectorTableMetadata tableMetadata) {
        Long tableId = (Long)this.dbi.inTransaction((TransactionCallback)new TransactionCallback<Long>(){

            public Long inTransaction(final Handle handle, TransactionStatus status) throws Exception {
                return SqlUtils.runIgnoringConstraintViolation(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        MetadataDao dao = (MetadataDao)handle.attach(MetadataDao.class);
                        long tableId = dao.insertTable(NativeMetadata.this.connectorId, tableMetadata.getTable().getSchemaName(), tableMetadata.getTable().getTableName());
                        int ordinalPosition = 0;
                        for (ColumnMetadata column : tableMetadata.getColumns()) {
                            long columnId = ordinalPosition + 1;
                            dao.insertColumn(tableId, columnId, column.getName(), ordinalPosition, TupleInfo.Type.fromColumnType(column.getType()).getName());
                            ++ordinalPosition;
                        }
                        if (tableMetadata.isSampled()) {
                            dao.insertColumn(tableId, ordinalPosition + 1, "$sample_weight", ordinalPosition, TupleInfo.Type.FIXED_INT_64.getName());
                        }
                        return tableId;
                    }
                }, null);
            }
        });
        Preconditions.checkState((tableId != null ? 1 : 0) != 0, (String)"table %s already exists", (Object[])new Object[]{tableMetadata.getTable()});
        NativeColumnHandle sampleWeightColumnHandle = null;
        if (tableMetadata.isSampled()) {
            sampleWeightColumnHandle = new NativeColumnHandle("$sample_weight", tableMetadata.getColumns().size() + 1);
        }
        return new NativeTableHandle(tableMetadata.getTable().getSchemaName(), tableMetadata.getTable().getTableName(), tableId, sampleWeightColumnHandle);
    }

    public void dropTable(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof NativeTableHandle), (Object)"tableHandle is not an instance of NativeTableHandle");
        final long tableId = ((NativeTableHandle)tableHandle).getTableId();
        this.dbi.inTransaction((TransactionCallback)new VoidTransactionCallback(){

            protected void execute(Handle handle, TransactionStatus status) throws Exception {
                MetadataDaoUtils.dropTable(NativeMetadata.this.dao, tableId);
            }
        });
    }

    public boolean canHandle(OutputTableHandle tableHandle) {
        return tableHandle instanceof NativeOutputTableHandle;
    }

    public OutputTableHandle beginCreateTable(ConnectorTableMetadata tableMetadata) {
        ImmutableList.Builder columnHandles = ImmutableList.builder();
        ImmutableList.Builder columnTypes = ImmutableList.builder();
        long maxColumnId = 0L;
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            long columnId = column.getOrdinalPosition() + 1;
            maxColumnId = Math.max(maxColumnId, columnId);
            columnHandles.add((Object)new NativeColumnHandle(column.getName(), columnId));
            columnTypes.add((Object)column.getType());
        }
        NativeColumnHandle sampleWeightColumnHandle = null;
        if (tableMetadata.isSampled()) {
            sampleWeightColumnHandle = new NativeColumnHandle("$sample_weight", maxColumnId + 1L);
            columnHandles.add((Object)sampleWeightColumnHandle);
            columnTypes.add((Object)ColumnType.LONG);
        }
        return new NativeOutputTableHandle(tableMetadata.getTable().getSchemaName(), tableMetadata.getTable().getTableName(), (List<NativeColumnHandle>)columnHandles.build(), (List<ColumnType>)columnTypes.build(), sampleWeightColumnHandle);
    }

    public void commitCreateTable(OutputTableHandle outputTableHandle, Collection<String> fragments) {
        final NativeOutputTableHandle table = Types.checkType(outputTableHandle, NativeOutputTableHandle.class, "outputTableHandle");
        this.dbi.inTransaction((TransactionCallback)new VoidTransactionCallback(){

            protected void execute(Handle dbiHandle, TransactionStatus status) {
                MetadataDao dao = (MetadataDao)dbiHandle.attach(MetadataDao.class);
                long tableId = dao.insertTable(NativeMetadata.this.connectorId, table.getSchemaName(), table.getTableName());
                for (int i = 0; i < table.getColumnTypes().size(); ++i) {
                    NativeColumnHandle column = table.getColumnHandles().get(i);
                    ColumnType columnType = table.getColumnTypes().get(i);
                    dao.insertColumn(tableId, i + 1, column.getColumnName(), i, TupleInfo.Type.fromColumnType(columnType).getName());
                }
            }
        });
        ImmutableMap.Builder shards = ImmutableMap.builder();
        for (String fragment : fragments) {
            Iterator split = Splitter.on((char)':').split((CharSequence)fragment).iterator();
            String nodeId = (String)split.next();
            UUID shardUuid = UUID.fromString((String)split.next());
            shards.put((Object)shardUuid, (Object)nodeId);
        }
        TableHandle tableHandle = this.getTableHandle(new SchemaTableName(table.getSchemaName(), table.getTableName()));
        this.shardManager.commitUnpartitionedTable(tableHandle, (Map<UUID, String>)shards.build());
    }
}

