/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.NativeColumnHandle;
import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.OutputTableHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public class NativeOutputTableHandle
implements OutputTableHandle {
    private final String schemaName;
    private final String tableName;
    private final List<NativeColumnHandle> columnHandles;
    private final List<ColumnType> columnTypes;
    @Nullable
    private final NativeColumnHandle sampleWeightColumnHandle;

    @JsonCreator
    public NativeOutputTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="columnHandles") List<NativeColumnHandle> columnHandles, @JsonProperty(value="columnTypes") List<ColumnType> columnTypes, @JsonProperty(value="sampleWeightColumnHandle") NativeColumnHandle sampleWeightColumnHandle) {
        this.schemaName = MetadataUtil.checkSchemaName(schemaName);
        this.tableName = MetadataUtil.checkTableName(tableName);
        this.columnHandles = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(columnHandles, (Object)"columnHandles is null")));
        this.columnTypes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(columnTypes, (Object)"columnTypes is null")));
        this.sampleWeightColumnHandle = sampleWeightColumnHandle;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public List<NativeColumnHandle> getColumnHandles() {
        return this.columnHandles;
    }

    @JsonProperty
    public List<ColumnType> getColumnTypes() {
        return this.columnTypes;
    }

    @JsonProperty
    public NativeColumnHandle getSampleWeightColumnHandle() {
        return this.sampleWeightColumnHandle;
    }

    public String toString() {
        return "native:" + this.schemaName + "." + this.tableName;
    }
}

