/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.metadata.ColumnFileHandle;
import com.facebook.presto.metadata.LocalStorageManager;
import com.facebook.presto.metadata.NativeColumnHandle;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.RecordSink;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;

public class NativeRecordSink
implements RecordSink {
    private final String nodeId;
    private final ColumnFileHandle fileHandle;
    private final LocalStorageManager storageManager;
    private final PageBuilder pageBuilder;
    private final int sampleWeightField;
    private int field = -1;

    public NativeRecordSink(String nodeId, ColumnFileHandle fileHandle, LocalStorageManager storageManager, List<ColumnType> columnTypes, NativeColumnHandle sampleWeightColumnHandle) {
        this.nodeId = (String)Preconditions.checkNotNull((Object)nodeId, (Object)"nodeId is null");
        this.fileHandle = (ColumnFileHandle)Preconditions.checkNotNull((Object)fileHandle, (Object)"fileHandle is null");
        this.storageManager = (LocalStorageManager)Preconditions.checkNotNull((Object)storageManager, (Object)"storageManager is null");
        List<TupleInfo> tupleInfos = NativeRecordSink.toTupleInfos(columnTypes);
        if (sampleWeightColumnHandle != null) {
            Preconditions.checkArgument((boolean)sampleWeightColumnHandle.getColumnName().equals("$sample_weight"), (Object)"sample weight column handle has wrong name");
            this.sampleWeightField = columnTypes.size() - 1;
        } else {
            this.sampleWeightField = -1;
        }
        this.pageBuilder = new PageBuilder(tupleInfos);
    }

    public void beginRecord(long sampleWeight) {
        Preconditions.checkState((this.field == -1 ? 1 : 0) != 0, (Object)"already in record");
        this.field = 0;
        if (this.sampleWeightField >= 0) {
            this.pageBuilder.getBlockBuilder(this.sampleWeightField).append(sampleWeight);
        }
    }

    private int lastField() {
        return this.fileHandle.getFieldCount() - (this.sampleWeightField != -1 ? 1 : 0);
    }

    public void finishRecord() {
        Preconditions.checkState((this.field != -1 ? 1 : 0) != 0, (Object)"not in record");
        Preconditions.checkState((this.field == this.lastField() ? 1 : 0) != 0, (Object)"not all fields set");
        this.field = -1;
        if (this.pageBuilder.isFull()) {
            this.fileHandle.append(this.pageBuilder.build());
            this.pageBuilder.reset();
        }
    }

    public void appendNull() {
        this.nextColumn().appendNull();
    }

    public void appendBoolean(boolean value) {
        this.nextColumn().append(value);
    }

    public void appendLong(long value) {
        this.nextColumn().append(value);
    }

    public void appendDouble(double value) {
        this.nextColumn().append(value);
    }

    public void appendString(byte[] value) {
        this.nextColumn().append(value);
    }

    public String commit() {
        Preconditions.checkState((this.field == -1 ? 1 : 0) != 0, (Object)"record not finished");
        if (!this.pageBuilder.isEmpty()) {
            this.fileHandle.append(this.pageBuilder.build());
        }
        try {
            this.storageManager.commit(this.fileHandle);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return Joiner.on((char)':').join((Object)this.nodeId, (Object)this.fileHandle.getShardUuid(), new Object[0]);
    }

    private BlockBuilder nextColumn() {
        Preconditions.checkState((this.field != -1 ? 1 : 0) != 0, (Object)"not in record");
        Preconditions.checkState((this.field < this.lastField() ? 1 : 0) != 0, (Object)"all fields already set");
        BlockBuilder builder = this.pageBuilder.getBlockBuilder(this.field);
        ++this.field;
        return builder;
    }

    private static List<TupleInfo> toTupleInfos(List<ColumnType> columnTypes) {
        ImmutableList.Builder tupleInfos = ImmutableList.builder();
        for (ColumnType columnType : columnTypes) {
            tupleInfos.add((Object)new TupleInfo(TupleInfo.Type.fromColumnType(columnType)));
        }
        return tupleInfos.build();
    }
}

