/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.ColumnFileHandle;
import com.facebook.presto.metadata.LocalStorageManager;
import com.facebook.presto.metadata.NativeColumnHandle;
import com.facebook.presto.metadata.NativeOutputTableHandle;
import com.facebook.presto.metadata.NativeRecordSink;
import com.facebook.presto.spi.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.OutputTableHandle;
import com.facebook.presto.spi.RecordSink;
import com.facebook.presto.util.Types;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.airlift.node.NodeInfo;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;

public class NativeRecordSinkProvider
implements ConnectorRecordSinkProvider {
    private final LocalStorageManager storageManager;
    private final String nodeId;

    @Inject
    public NativeRecordSinkProvider(LocalStorageManager storageManager, NodeInfo nodeInfo) {
        this(storageManager, ((NodeInfo)Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null")).getNodeId());
    }

    public NativeRecordSinkProvider(LocalStorageManager storageManager, String nodeId) {
        this.storageManager = (LocalStorageManager)Preconditions.checkNotNull((Object)storageManager, (Object)"storageManager is null");
        this.nodeId = (String)Preconditions.checkNotNull((Object)nodeId, (Object)"nodeId is null");
    }

    public boolean canHandle(OutputTableHandle tableHandle) {
        return tableHandle instanceof NativeOutputTableHandle;
    }

    public RecordSink getRecordSink(OutputTableHandle tableHandle) {
        NativeOutputTableHandle handle = Types.checkType(tableHandle, NativeOutputTableHandle.class, "tableHandle");
        ColumnFileHandle fileHandle = this.createStagingFileHandle(handle.getColumnHandles());
        return new NativeRecordSink(this.nodeId, fileHandle, this.storageManager, handle.getColumnTypes(), ((NativeOutputTableHandle)tableHandle).getSampleWeightColumnHandle());
    }

    private ColumnFileHandle createStagingFileHandle(List<NativeColumnHandle> columnHandles) {
        try {
            return this.storageManager.createStagingFileHandles(UUID.randomUUID(), columnHandles);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

