/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.spi.ConnectorOutputHandleResolver;
import com.facebook.presto.spi.OutputTableHandle;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class OutputTableHandleResolver {
    private final ConcurrentMap<String, ConnectorOutputHandleResolver> handleIdResolvers = new ConcurrentHashMap<String, ConnectorOutputHandleResolver>();

    public OutputTableHandleResolver() {
    }

    @Inject
    public OutputTableHandleResolver(Map<String, ConnectorOutputHandleResolver> handleIdResolvers) {
        this.handleIdResolvers.putAll(handleIdResolvers);
    }

    public void addHandleResolver(String id, ConnectorOutputHandleResolver resolver) {
        ConnectorOutputHandleResolver existingResolver = this.handleIdResolvers.putIfAbsent(id, resolver);
        Preconditions.checkState((existingResolver == null ? 1 : 0) != 0, (String)"Id %s is already assigned to resolver %s", (Object[])new Object[]{id, existingResolver});
    }

    public String getId(OutputTableHandle tableHandle) {
        for (Map.Entry entry : this.handleIdResolvers.entrySet()) {
            if (!((ConnectorOutputHandleResolver)entry.getValue()).canHandle(tableHandle)) continue;
            return (String)entry.getKey();
        }
        throw new IllegalArgumentException("No connector for output table handle: " + tableHandle);
    }

    public Class<? extends OutputTableHandle> getOutputTableHandleClass(String id) {
        ConnectorOutputHandleResolver resolver = (ConnectorOutputHandleResolver)this.handleIdResolvers.get(id);
        Preconditions.checkArgument((resolver != null ? 1 : 0) != 0, (String)"No handle resolver for %s", (Object[])new Object[]{id});
        return resolver.getOutputTableHandleClass();
    }
}

