/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.ForShardCleaner;
import com.facebook.presto.metadata.PrestoNode;
import com.facebook.presto.metadata.ShardCleanerConfig;
import com.facebook.presto.metadata.ShardManager;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.util.KeyBoundedExecutor;
import com.facebook.presto.util.Threads;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.inject.Inject;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StatusResponseHandler;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public class ShardCleaner {
    private static final Logger log = Logger.get(ShardCleaner.class);
    private final NodeManager nodeManager;
    private final ShardManager shardManager;
    private final HttpClient httpClient;
    private final Duration interval;
    private final boolean enabled;
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed("shard-cleaner-%s"));
    private final AtomicReference<ScheduledFuture<?>> scheduledFuture = new AtomicReference();
    private final KeyBoundedExecutor<String> nodeBoundedExecutor;

    @Inject
    public ShardCleaner(NodeManager nodeManager, ShardManager shardManager, @ForShardCleaner HttpClient httpClient, ShardCleanerConfig config) {
        this.nodeManager = (NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
        this.shardManager = (ShardManager)Preconditions.checkNotNull((Object)shardManager, (Object)"shardManager is null");
        this.httpClient = (HttpClient)Preconditions.checkNotNull((Object)httpClient, (Object)"httpClient is null");
        Preconditions.checkNotNull((Object)config, (Object)"config is null");
        this.interval = config.getCleanerInterval();
        ScheduledExecutorService nodeExecutor = Executors.newScheduledThreadPool(config.getMaxThreads(), Threads.daemonThreadsNamed("shard-cleaner-worker-%s"));
        this.nodeBoundedExecutor = new KeyBoundedExecutor(nodeExecutor, config.getMaxThreads());
        this.enabled = config.isEnabled();
    }

    @PostConstruct
    public void start() {
        if (this.enabled && this.started.compareAndSet(false, true)) {
            this.scheduledFuture.set(this.executorService.scheduleAtFixedRate(new ShardCleanerRunnable(), this.interval.toMillis(), this.interval.toMillis(), TimeUnit.MILLISECONDS));
        }
    }

    @PreDestroy
    public void stop() {
        if (!this.stopped.compareAndSet(false, true)) {
            this.executorService.shutdownNow();
        }
    }

    private static URI uriAppendPaths(URI uri, String path, String ... additionalPaths) {
        HttpUriBuilder builder = HttpUriBuilder.uriBuilderFrom((URI)uri);
        builder.appendPath(path);
        for (String additionalPath : additionalPaths) {
            builder.appendPath(additionalPath);
        }
        return builder.build();
    }

    private class ShardDropJob
    implements Runnable {
        private final long shardId;
        private final Node node;

        private ShardDropJob(long shardId, Node node) {
            this.shardId = shardId;
            this.node = node;
        }

        @Override
        public void run() {
            try {
                if (!this.dropShardRequest()) {
                    throw new RuntimeException("Failed to drop shard " + this.shardId + " for " + this.node);
                }
                ShardCleaner.this.shardManager.disassociateShard(this.shardId, this.node.getNodeIdentifier());
            }
            catch (RuntimeException e) {
                log.error((Throwable)e);
            }
        }

        private boolean dropShardRequest() {
            StatusResponseHandler.StatusResponse response;
            URI shardUri = ShardCleaner.uriAppendPaths(this.node.getHttpUri(), "/v1/shard/" + this.shardId, new String[0]);
            Request request = Request.Builder.prepareDelete().setUri(shardUri).build();
            try {
                response = (StatusResponseHandler.StatusResponse)ShardCleaner.this.httpClient.execute(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
            }
            catch (RuntimeException e) {
                log.warn("drop request failed: %s. Cause: %s", new Object[]{this.shardId, e.getMessage()});
                return false;
            }
            if (response.getStatusCode() != HttpStatus.ACCEPTED.code()) {
                log.warn("unexpected response status: %s: %s", new Object[]{this.shardId, response.getStatusCode()});
                return false;
            }
            log.debug("initiated drop shard: %s", new Object[]{this.shardId});
            return true;
        }
    }

    private class ShardCleanerRunnable
    implements Runnable {
        private ShardCleanerRunnable() {
        }

        @Override
        public void run() {
            try {
                ImmutableMap activeNodes = Maps.uniqueIndex((Iterable)ShardCleaner.this.nodeManager.getActiveNodes(), PrestoNode.getIdentifierFunction());
                Iterable<String> shardNodes = ShardCleaner.this.shardManager.getAllNodesInUse();
                ImmutableList.Builder builder = ImmutableList.builder();
                for (String nodeIdentifier : shardNodes) {
                    if (!activeNodes.keySet().contains(nodeIdentifier)) {
                        log.debug("Skipping Node %s, which is in the database but not active!", new Object[]{nodeIdentifier});
                        continue;
                    }
                    Iterable<Long> orphanedShards = ShardCleaner.this.shardManager.getOrphanedShardIds((Optional<String>)Optional.of((Object)nodeIdentifier));
                    Node node = (Node)activeNodes.get(nodeIdentifier);
                    for (Long shardId : orphanedShards) {
                        ListenableFutureTask task = ListenableFutureTask.create((Runnable)new ShardDropJob(shardId, node), null);
                        ShardCleaner.this.nodeBoundedExecutor.execute(nodeIdentifier, (Runnable)task);
                        builder.add((Object)task);
                    }
                }
                ListenableFuture allFutures = Futures.allAsList((Iterable)builder.build());
                try {
                    allFutures.get();
                }
                catch (ExecutionException e) {
                    throw e.getCause();
                }
                Iterable<Long> allOrphanedShards = ShardCleaner.this.shardManager.getOrphanedShardIds((Optional<String>)Optional.absent());
                for (Long shardId : allOrphanedShards) {
                    ShardCleaner.this.shardManager.dropShard(shardId);
                }
                ShardCleaner.this.shardManager.dropOrphanedPartitions();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable e) {
                log.error(e, "Caught problem when dropping orphaned shards!");
            }
        }
    }
}

