/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class ShardCleanerConfig {
    private boolean enabled = false;
    private Duration storageCleanerInterval = new Duration(60.0, TimeUnit.SECONDS);
    private int maxShardDropThreads = 32;

    public boolean isEnabled() {
        return this.enabled;
    }

    @Config(value="shard-cleaner.enabled")
    @ConfigDescription(value="Run the periodic importer")
    public ShardCleanerConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @MinDuration(value="60s")
    @NotNull
    public Duration getCleanerInterval() {
        return this.storageCleanerInterval;
    }

    @Config(value="shard-cleaner.interval")
    public ShardCleanerConfig setCleanerInterval(Duration storageCleanerInterval) {
        this.storageCleanerInterval = storageCleanerInterval;
        return this;
    }

    @Min(value=1L)
    public int getMaxThreads() {
        return this.maxShardDropThreads;
    }

    @Config(value="shard-cleaner.max-threads")
    public ShardCleanerConfig setMaxThreads(int maxShardDropThreads) {
        this.maxShardDropThreads = maxShardDropThreads;
        return this;
    }
}

