/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.UuidArguments;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class ShardNode {
    private final UUID shardUuid;
    private final String nodeIdentifier;
    private final long tableId;
    private final long partitionId;

    public ShardNode(UUID shardUuid, String nodeIdentifier, long tableId, long partitionId) {
        this.shardUuid = (UUID)Preconditions.checkNotNull((Object)shardUuid, (Object)"shardUuid is null");
        this.nodeIdentifier = (String)Preconditions.checkNotNull((Object)nodeIdentifier, (Object)"nodeIdentifier is null");
        this.tableId = tableId;
        this.partitionId = partitionId;
    }

    public UUID getShardUuid() {
        return this.shardUuid;
    }

    public String getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public long getTableId() {
        return this.tableId;
    }

    public long getPartitionId() {
        return this.partitionId;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("shardUuid", (Object)this.shardUuid).add("nodeIdentifier", (Object)this.nodeIdentifier).add("tableId", this.tableId).add("partitionId", this.partitionId).toString();
    }

    public static class Mapper
    implements ResultSetMapper<ShardNode> {
        public ShardNode map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return new ShardNode(UuidArguments.uuidFromBytes(r.getBytes("shard_uuid")), r.getString("node_identifier"), r.getLong("table_id"), r.getLong("partition_id"));
        }
    }
}

