/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.sql.analyzer.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public final class Signature {
    private final String name;
    private final Type returnType;
    private final List<Type> argumentTypes;
    private final boolean approximate;

    @JsonCreator
    public Signature(@JsonProperty(value="name") String name, @JsonProperty(value="returnType") Type returnType, @JsonProperty(value="argumentTypes") List<Type> argumentTypes, @JsonProperty(value="approximate") boolean approximate) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull((Object)((Object)returnType), (Object)"returnType is null");
        Preconditions.checkNotNull(argumentTypes, (Object)"argumentTypes is null");
        this.name = name;
        this.returnType = returnType;
        this.argumentTypes = ImmutableList.copyOf(argumentTypes);
        this.approximate = approximate;
    }

    @JsonProperty
    public boolean isApproximate() {
        return this.approximate;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Type getReturnType() {
        return this.returnType;
    }

    @JsonProperty
    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.returnType, this.argumentTypes, this.approximate});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Signature other = (Signature)obj;
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.returnType, (Object)other.returnType) && Objects.equals(this.argumentTypes, other.argumentTypes) && Objects.equals(this.approximate, other.approximate);
    }

    public String toString() {
        return this.name + (this.approximate ? "[approximate]" : "") + "(" + Joiner.on((String)",").join(this.argumentTypes) + "):" + (Object)((Object)this.returnType);
    }
}

