/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.UuidArguments;
import java.util.List;
import java.util.UUID;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterArgumentFactory;

@RegisterArgumentFactory(value={UuidArguments.UuidArgumentFactory.class})
public interface StorageManagerDao {
    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS columns (\n  shard_uuid BINARY(16) NOT NULL,\n  column_id BIGINT NOT NULL,\n  filename VARCHAR(255) NOT NULL,\n  PRIMARY KEY (shard_uuid, column_id)\n)")
    public void createTableColumns();

    @SqlUpdate(value="INSERT INTO columns (shard_uuid, column_id, filename)\nVALUES (:shardUuid, :columnId, :filename)")
    public void insertColumn(@Bind(value="shardUuid") UUID var1, @Bind(value="columnId") long var2, @Bind(value="filename") String var4);

    @SqlQuery(value="SELECT filename\nFROM columns\nWHERE shard_uuid = :shardUuid\n  AND column_id = :columnId")
    public String getColumnFilename(@Bind(value="shardUuid") UUID var1, @Bind(value="columnId") long var2);

    @SqlQuery(value="SELECT filename\nFROM columns\nWHERE shard_uuid = :shardUuid")
    public List<String> getShardFiles(@Bind(value="shardUuid") UUID var1);

    @SqlQuery(value="SELECT COUNT(*) > 0\nFROM columns\nWHERE shard_uuid = :shardUuid")
    public boolean shardExists(@Bind(value="shardUuid") UUID var1);

    @SqlUpdate(value="DELETE FROM columns\nWHERE shard_uuid = :shardUuid")
    public void dropShard(@Bind(value="shardUuid") UUID var1);
}

