/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class TableColumn {
    private final QualifiedTableName table;
    private final String columnName;
    private final int ordinalPosition;
    private final TupleInfo.Type dataType;
    private final long columnId;

    public TableColumn(QualifiedTableName table, String columnName, int ordinalPosition, TupleInfo.Type dataType, long columnId) {
        this.table = MetadataUtil.checkTable(table);
        this.columnName = (String)Preconditions.checkNotNull((Object)columnName, (Object)"columnName is null");
        Preconditions.checkArgument((ordinalPosition >= 0 ? 1 : 0) != 0, (Object)"ordinal position is negative");
        this.ordinalPosition = ordinalPosition;
        this.dataType = (TupleInfo.Type)Preconditions.checkNotNull((Object)dataType, (Object)"dataType is null");
        this.columnId = columnId;
    }

    public QualifiedTableName getTable() {
        return this.table;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public TupleInfo.Type getDataType() {
        return this.dataType;
    }

    public long getColumnId() {
        return this.columnId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.table, this.columnName, this.ordinalPosition, this.dataType});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TableColumn o = (TableColumn)obj;
        return Objects.equal((Object)this.table, (Object)o.table) && Objects.equal((Object)this.columnName, (Object)o.columnName) && Objects.equal((Object)this.ordinalPosition, (Object)o.ordinalPosition) && Objects.equal((Object)this.dataType, (Object)o.dataType);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("table", (Object)this.table).add("columnName", (Object)this.columnName).add("ordinalPosition", this.ordinalPosition).add("dataType", (Object)this.dataType).toString();
    }
}

