/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class TablePartition {
    private final long partitionId;
    private final String partitionName;
    private final long tableId;

    TablePartition(long partitionId, String partitionName, long tableId) {
        this.partitionId = partitionId;
        this.partitionName = (String)Preconditions.checkNotNull((Object)partitionName, (Object)"partitionName is null");
        this.tableId = tableId;
    }

    public long getPartitionId() {
        return this.partitionId;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public long getTableId() {
        return this.tableId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.partitionId, this.partitionName, this.tableId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TablePartition other = (TablePartition)obj;
        return Objects.equal((Object)this.partitionId, (Object)other.partitionId) && Objects.equal((Object)this.partitionName, (Object)other.partitionName) && Objects.equal((Object)this.tableId, (Object)other.tableId);
    }

    public static Function<TablePartition, String> partitionNameGetter() {
        return new Function<TablePartition, String>(){

            public String apply(TablePartition partition) {
                return partition.getPartitionName();
            }
        };
    }

    public static Function<TablePartition, Long> partitionIdGetter() {
        return new Function<TablePartition, Long>(){

            public Long apply(TablePartition partition) {
                return partition.getPartitionId();
            }
        };
    }

    public static class Mapper
    implements ResultSetMapper<TablePartition> {
        public TablePartition map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return new TablePartition(r.getLong("partition_id"), r.getString("partition_name"), r.getLong("table_id"));
        }
    }
}

