/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

public final class UuidArguments {
    private UuidArguments() {
    }

    public static UUID uuidFromBytes(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long msb = buffer.getLong();
        long lsb = buffer.getLong();
        return new UUID(msb, lsb);
    }

    public static byte[] uuidToBytes(UUID uuid) {
        return ByteBuffer.allocate(16).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).array();
    }

    public static final class UuidArgument
    implements Argument {
        private final byte[] value;

        public UuidArgument(UUID value) {
            this.value = UuidArguments.uuidToBytes((UUID)Preconditions.checkNotNull((Object)value, (Object)"value is null"));
        }

        public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
            statement.setBytes(position, this.value);
        }
    }

    public static final class UuidArgumentFactory
    implements ArgumentFactory<UUID> {
        public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
            return value instanceof UUID;
        }

        public Argument build(Class<?> expectedType, UUID value, StatementContext ctx) {
            return new UuidArgument(value);
        }
    }
}

