/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.RecordProjectOperator;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.Split;
import com.facebook.presto.split.DataStreamProvider;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.io.Closeable;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

public abstract class AbstractScanFilterAndProjectOperator
implements SourceOperator,
Closeable {
    private final OperatorContext operatorContext;
    private final PlanNodeId planNodeId;
    private final DataStreamProvider dataStreamProvider;
    private final List<TupleInfo> tupleInfos;
    private final List<ColumnHandle> columns;
    private final PageBuilder pageBuilder;
    @GuardedBy(value="this")
    private RecordCursor cursor;
    @GuardedBy(value="this")
    private Operator operator;
    private boolean finishing;
    private long completedBytes;

    protected AbstractScanFilterAndProjectOperator(OperatorContext operatorContext, PlanNodeId sourceId, DataStreamProvider dataStreamProvider, Iterable<ColumnHandle> columns, Iterable<TupleInfo> tupleInfos) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.planNodeId = (PlanNodeId)Preconditions.checkNotNull((Object)sourceId, (Object)"sourceId is null");
        this.dataStreamProvider = (DataStreamProvider)Preconditions.checkNotNull((Object)dataStreamProvider, (Object)"dataStreamProvider is null");
        this.tupleInfos = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(tupleInfos, (Object)"tupleInfos is null")));
        this.columns = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(columns, (Object)"columns is null")));
        this.pageBuilder = new PageBuilder(this.getTupleInfos());
    }

    protected abstract void filterAndProjectRowOriented(Page var1, PageBuilder var2);

    protected abstract int filterAndProjectRowOriented(RecordCursor var1, PageBuilder var2);

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.planNodeId;
    }

    @Override
    public synchronized void addSplit(Split split) {
        Preconditions.checkNotNull((Object)split, (Object)"split is null");
        Preconditions.checkState((this.cursor == null && this.operator == null ? 1 : 0) != 0, (Object)"split already set");
        Operator dataStream = this.dataStreamProvider.createNewDataStream(this.operatorContext, split, this.columns);
        if (dataStream instanceof RecordProjectOperator) {
            this.cursor = ((RecordProjectOperator)dataStream).getCursor();
        } else {
            this.operator = dataStream;
        }
        Object splitInfo = split.getInfo();
        if (splitInfo != null) {
            this.operatorContext.setInfoSupplier((Supplier<Object>)Suppliers.ofInstance((Object)splitInfo));
        }
    }

    @Override
    public synchronized void noMoreSplits() {
        if (this.cursor == null && this.operator == null) {
            this.finishing = true;
        }
    }

    @Override
    public final List<TupleInfo> getTupleInfos() {
        return this.tupleInfos;
    }

    @Override
    public final void finish() {
        this.close();
    }

    @Override
    public void close() {
        if (this.operator != null) {
            this.operator.finish();
        } else if (this.cursor != null) {
            this.cursor.close();
        }
        this.finishing = true;
    }

    @Override
    public final boolean isFinished() {
        if (this.operator != null && this.operator.isFinished()) {
            this.finishing = true;
        }
        return this.finishing && this.pageBuilder.isEmpty();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.operator != null) {
            return this.operator.isBlocked();
        }
        return NOT_BLOCKED;
    }

    @Override
    public final boolean needsInput() {
        return false;
    }

    @Override
    public final void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        if (!this.finishing) {
            if (this.cursor != null) {
                int rowsProcessed = this.filterAndProjectRowOriented(this.cursor, this.pageBuilder);
                long bytesProcessed = this.cursor.getCompletedBytes() - this.completedBytes;
                this.operatorContext.recordGeneratedInput(new DataSize((double)bytesProcessed, DataSize.Unit.BYTE), rowsProcessed);
                this.completedBytes += bytesProcessed;
                if (rowsProcessed == 0) {
                    this.finishing = true;
                }
            } else {
                Page output = this.operator.getOutput();
                if (output != null) {
                    this.filterAndProjectRowOriented(output, this.pageBuilder);
                }
            }
        }
        if (this.pageBuilder.isEmpty() || !this.finishing && !this.pageBuilder.isFull()) {
            return null;
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        return page;
    }
}

