/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.sql.tree.Input;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.List;

public class AggregationFunctionDefinition {
    private final AggregationFunction function;
    private final List<Input> inputs;
    private final Optional<Input> mask;
    private final Optional<Input> sampleWeight;
    private final double confidence;

    public static AggregationFunctionDefinition aggregation(AggregationFunction function, List<Input> inputs, Optional<Input> mask, Optional<Input> sampleWeight, double confidence) {
        Preconditions.checkNotNull((Object)function, (Object)"function is null");
        Preconditions.checkNotNull(inputs, (Object)"inputs is null");
        return new AggregationFunctionDefinition(function, inputs, mask, sampleWeight, confidence);
    }

    AggregationFunctionDefinition(AggregationFunction function, List<Input> inputs, Optional<Input> mask, Optional<Input> sampleWeight, double confidence) {
        this.function = function;
        this.inputs = inputs;
        this.mask = mask;
        this.sampleWeight = sampleWeight;
        this.confidence = confidence;
    }

    public AggregationFunction getFunction() {
        return this.function;
    }

    public List<Input> getInputs() {
        return this.inputs;
    }

    public Optional<Input> getMask() {
        return this.mask;
    }

    public Optional<Input> getSampleWeight() {
        return this.sampleWeight;
    }

    public double getConfidence() {
        return this.confidence;
    }
}

