/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.block.BlockIterable;
import com.facebook.presto.block.BlockIterables;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AlignmentOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<TupleInfo> tupleInfos;
    private final Optional<DataSize> expectedDataSize;
    private final Optional<Integer> expectedPositionCount;
    private final List<Iterator<Block>> iterators;
    private final List<BlockCursor> cursors;
    private boolean finished;

    public AlignmentOperator(OperatorContext operatorContext, BlockIterable ... channels) {
        this(operatorContext, (Iterable<BlockIterable>)ImmutableList.copyOf((Object[])channels));
    }

    public AlignmentOperator(OperatorContext operatorContext, Iterable<BlockIterable> channels) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.tupleInfos = AlignmentOperator.toTupleInfos((Iterable)Preconditions.checkNotNull(channels, (Object)"channels is null"));
        this.expectedDataSize = BlockIterables.getDataSize(channels);
        this.expectedPositionCount = BlockIterables.getPositionCount(channels);
        ImmutableList.Builder iterators = ImmutableList.builder();
        for (BlockIterable blockIterable : channels) {
            iterators.add(blockIterable.iterator());
        }
        this.iterators = iterators.build();
        this.cursors = new ArrayList<BlockCursor>(this.iterators.size());
        if (this.iterators.get(0).hasNext()) {
            for (Iterator iterator : this.iterators) {
                this.cursors.add(((Block)iterator.next()).cursor());
            }
        } else {
            for (Iterator iterator : this.iterators) {
                Preconditions.checkState((!iterator.hasNext() ? 1 : 0) != 0);
            }
            this.finished = true;
        }
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<TupleInfo> getTupleInfos() {
        return this.tupleInfos;
    }

    public Optional<DataSize> getExpectedDataSize() {
        return this.expectedDataSize;
    }

    public Optional<Integer> getExpectedPositionCount() {
        return this.expectedPositionCount;
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException(this.getClass().getName() + " can not take input");
    }

    @Override
    public Page getOutput() {
        if (this.finished) {
            return null;
        }
        if (this.cursors.get(0).getRemainingPositions() <= 0 && !this.iterators.get(0).hasNext()) {
            for (Iterator<Block> iterator : this.iterators) {
                Preconditions.checkState((!iterator.hasNext() ? 1 : 0) != 0);
            }
            this.finished = true;
            return null;
        }
        int length = Integer.MAX_VALUE;
        for (int i = 0; i < this.iterators.size(); ++i) {
            Iterator<Block> iterator = this.iterators.get(i);
            BlockCursor cursor = this.cursors.get(i);
            if (cursor.getRemainingPositions() <= 0) {
                cursor = iterator.next().cursor();
                this.cursors.set(i, cursor);
            }
            length = Math.min(length, cursor.getRemainingPositions());
        }
        Block[] blocks = new Block[this.iterators.size()];
        for (int i = 0; i < this.cursors.size(); ++i) {
            blocks[i] = this.cursors.get(i).getRegionAndAdvance(length);
        }
        Page page = new Page(blocks);
        this.operatorContext.recordGeneratedInput(page.getDataSize(), page.getPositionCount());
        return page;
    }

    private static List<TupleInfo> toTupleInfos(Iterable<BlockIterable> channels) {
        ImmutableList.Builder tupleInfos = ImmutableList.builder();
        for (BlockIterable channel : channels) {
            tupleInfos.add((Object)channel.getTupleInfo());
        }
        return tupleInfos.build();
    }

    public static class AlignmentOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final List<BlockIterable> channels;
        private final List<TupleInfo> tupleInfos;
        private boolean closed;

        public AlignmentOperatorFactory(int operatorId, BlockIterable firstChannel, BlockIterable ... otherChannels) {
            this(operatorId, (Iterable<BlockIterable>)ImmutableList.builder().add(Preconditions.checkNotNull((Object)firstChannel, (Object)"firstChannel is null")).add((Object[])Preconditions.checkNotNull((Object)otherChannels, (Object)"otherChannels is null")).build());
        }

        public AlignmentOperatorFactory(int operatorId, Iterable<BlockIterable> channels) {
            this.operatorId = operatorId;
            this.channels = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(channels, (Object)"channels is null")));
            this.tupleInfos = AlignmentOperator.toTupleInfos(channels);
        }

        @Override
        public List<TupleInfo> getTupleInfos() {
            return this.tupleInfos;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, AlignmentOperator.class.getSimpleName());
            return new AlignmentOperator(operatorContext, this.channels);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

