/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.block.uncompressed.UncompressedBlock;
import com.facebook.presto.operator.HashStrategyUtils;
import com.facebook.presto.operator.SortOrder;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.Swapper;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;

public class ChannelIndex
implements LongIterable,
Swapper {
    private int positionCount;
    private final LongArrayList valueAddresses;
    private final ObjectArrayList<Slice> slices;
    private final TupleInfo tupleInfo;
    private long slicesMemorySize;
    private TupleInfo.Type type;

    public ChannelIndex(int expectedPositions, TupleInfo tupleInfo) {
        this.tupleInfo = tupleInfo;
        this.valueAddresses = new LongArrayList(expectedPositions);
        this.slices = ObjectArrayList.wrap((Object[])new Slice[1024], (int)0);
        this.type = tupleInfo.getType();
    }

    public DataSize getEstimatedSize() {
        long sliceArraySize = SizeOf.sizeOf((Object[])this.slices.elements());
        long addressesArraySize = SizeOf.sizeOf((long[])this.valueAddresses.elements());
        return new DataSize((double)(this.slicesMemorySize + sliceArraySize + addressesArraySize), DataSize.Unit.BYTE);
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public TupleInfo getTupleInfo() {
        return this.tupleInfo;
    }

    public ObjectArrayList<Slice> getSlices() {
        return this.slices;
    }

    public LongArrayList getValueAddresses() {
        return this.valueAddresses;
    }

    public void swap(int a, int b) {
        long[] elements = this.valueAddresses.elements();
        long temp = elements[a];
        elements[a] = elements[b];
        elements[b] = temp;
    }

    public LongListIterator iterator() {
        return this.valueAddresses.iterator();
    }

    public void indexBlock(UncompressedBlock block) {
        Preconditions.checkNotNull((Object)block, (Object)"block is null");
        Preconditions.checkArgument((boolean)block.getTupleInfo().getType().equals(this.type), (String)"Expected block to be type %s, but is %s", (Object[])new Object[]{this.type, block.getTupleInfo().getType()});
        this.positionCount += block.getPositionCount();
        int blockIndex = this.slices.size();
        this.slices.add(blockIndex, (Object)block.getSlice());
        this.slicesMemorySize += (long)block.getSlice().length();
        BlockCursor cursor = block.cursor();
        for (int position = 0; position < block.getPositionCount(); ++position) {
            Preconditions.checkState((boolean)cursor.advanceNextPosition());
            int offset = cursor.getRawOffset();
            long sliceAddress = SyntheticAddress.encodeSyntheticAddress(blockIndex, offset);
            Preconditions.checkState(((int)(sliceAddress >> 32) == blockIndex ? 1 : 0) != 0);
            Preconditions.checkState(((int)sliceAddress == offset ? 1 : 0) != 0);
            this.valueAddresses.add(sliceAddress);
        }
    }

    public void appendTo(int position, BlockBuilder output) {
        long sliceAddress = this.valueAddresses.getLong(position);
        Slice slice = this.getSliceForSyntheticAddress(sliceAddress);
        int offset = SyntheticAddress.decodePosition(sliceAddress);
        output.appendTuple(slice, offset);
    }

    public Slice getSliceForSyntheticAddress(long sliceAddress) {
        return (Slice)this.slices.get(SyntheticAddress.decodeSliceIndex(sliceAddress));
    }

    public boolean equals(int leftPosition, int rightPosition) {
        long leftSliceAddress = this.valueAddresses.getLong(leftPosition);
        Slice leftSlice = this.getSliceForSyntheticAddress(leftSliceAddress);
        int leftOffset = SyntheticAddress.decodePosition(leftSliceAddress);
        long rightSliceAddress = this.valueAddresses.getLong(rightPosition);
        Slice rightSlice = this.getSliceForSyntheticAddress(rightSliceAddress);
        int rightOffset = SyntheticAddress.decodePosition(rightSliceAddress);
        return HashStrategyUtils.valueEquals(this.type, leftSlice, leftOffset, rightSlice, rightOffset);
    }

    public boolean equals(int position, BlockCursor cursor) {
        long sliceAddress = this.valueAddresses.getLong(position);
        Slice slice = this.getSliceForSyntheticAddress(sliceAddress);
        int offset = SyntheticAddress.decodePosition(sliceAddress);
        Slice rightSlice = cursor.getRawSlice();
        int rightOffset = cursor.getRawOffset();
        return HashStrategyUtils.valueEquals(this.type, slice, offset, rightSlice, rightOffset);
    }

    public int hashCode(int position) {
        long sliceAddress = this.valueAddresses.getLong(position);
        Slice slice = this.getSliceForSyntheticAddress(sliceAddress);
        int offset = SyntheticAddress.decodePosition(sliceAddress);
        return HashStrategyUtils.valueHashCode(this.type, slice, offset);
    }

    public int compare(SortOrder sortOrder, int leftPosition, int rightPosition) {
        int comparison;
        long leftSliceAddress = this.valueAddresses.getLong(leftPosition);
        Slice leftSlice = this.getSliceForSyntheticAddress(leftSliceAddress);
        int leftOffset = SyntheticAddress.decodePosition(leftSliceAddress);
        long rightSliceAddress = this.valueAddresses.getLong(rightPosition);
        Slice rightSlice = this.getSliceForSyntheticAddress(rightSliceAddress);
        int rightOffset = SyntheticAddress.decodePosition(rightSliceAddress);
        boolean leftIsNull = this.tupleInfo.isNull(leftSlice, leftOffset);
        boolean rightIsNull = this.tupleInfo.isNull(rightSlice, rightOffset);
        if (leftIsNull && rightIsNull) {
            return 0;
        }
        if (leftIsNull) {
            return sortOrder.isNullsFirst() ? -1 : 1;
        }
        if (rightIsNull) {
            return sortOrder.isNullsFirst() ? 1 : -1;
        }
        switch (this.type) {
            case BOOLEAN: {
                comparison = Boolean.compare(this.tupleInfo.getBoolean(leftSlice, leftOffset), this.tupleInfo.getBoolean(rightSlice, rightOffset));
                break;
            }
            case FIXED_INT_64: {
                comparison = Long.compare(this.tupleInfo.getLong(leftSlice, leftOffset), this.tupleInfo.getLong(rightSlice, rightOffset));
                break;
            }
            case DOUBLE: {
                comparison = Double.compare(this.tupleInfo.getDouble(leftSlice, leftOffset), this.tupleInfo.getDouble(rightSlice, rightOffset));
                break;
            }
            case VARIABLE_BINARY: {
                comparison = this.tupleInfo.getSlice(leftSlice, leftOffset).compareTo(this.tupleInfo.getSlice(rightSlice, rightOffset));
                break;
            }
            default: {
                throw new AssertionError((Object)("unimplemented type: " + this.type));
            }
        }
        return sortOrder.isAscending() ? comparison : -comparison;
    }
}

