/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.block.uncompressed.UncompressedBlock;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.SliceHashStrategy;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongHash;
import it.unimi.dsi.fastutil.longs.LongOpenCustomHashSet;

public class ChannelSet {
    private final SliceHashStrategy strategy;
    private final AddressValueSet addressValueSet;
    private final boolean containsNull;

    public ChannelSet(ChannelSet channelSet) {
        Preconditions.checkNotNull((Object)channelSet, (Object)"channelSet is null");
        this.strategy = new SliceHashStrategy(channelSet.strategy);
        this.addressValueSet = new AddressValueSet(channelSet.addressValueSet, (LongHash.Strategy)this.strategy);
        this.containsNull = channelSet.containsNull;
    }

    private ChannelSet(SliceHashStrategy strategy, AddressValueSet addressValueSet, boolean containsNull) {
        this.strategy = strategy;
        this.addressValueSet = addressValueSet;
        this.containsNull = containsNull;
    }

    public boolean containsNull() {
        return this.containsNull;
    }

    public void setLookupSlice(Slice lookupSlice) {
        this.strategy.setLookupSlice(lookupSlice);
    }

    public boolean contains(BlockCursor cursor) {
        return this.addressValueSet.contains(SyntheticAddress.encodeSyntheticAddress(-1, cursor.getRawOffset()));
    }

    public int size() {
        return this.addressValueSet.size();
    }

    public DataSize getEstimatedSize() {
        return new DataSize((double)(this.addressValueSet.getEstimatedSize().toBytes() + this.strategy.getEstimatedSize().toBytes()), DataSize.Unit.BYTE);
    }

    public static class ChannelSetBuilder {
        private final SliceHashStrategy strategy;
        private final AddressValueSet addressValueSet;
        private final OperatorContext operatorContext;
        private final TupleInfo tupleInfo;
        private int currentBlockId;
        private boolean containsNull;
        private BlockBuilder blockBuilder;

        public ChannelSetBuilder(TupleInfo tupleInfo, int expectedPositions, OperatorContext operatorContext) {
            this.tupleInfo = (TupleInfo)Preconditions.checkNotNull((Object)tupleInfo, (Object)"tupleInfo is null");
            Preconditions.checkArgument((expectedPositions >= 0 ? 1 : 0) != 0, (Object)"expectedPositions must be greater than or equal to zero");
            this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
            this.strategy = new SliceHashStrategy(tupleInfo);
            this.addressValueSet = new AddressValueSet(expectedPositions, (LongHash.Strategy)this.strategy);
            Slice slice = Slices.allocate((int)((int)BlockBuilder.DEFAULT_MAX_BLOCK_SIZE.toBytes()));
            this.strategy.addSlice(slice);
            this.blockBuilder = new BlockBuilder(tupleInfo, slice.length(), slice.getOutput());
        }

        public void addBlock(Block sourceBlock) {
            this.operatorContext.setMemoryReservation(this.getEstimatedSize());
            BlockCursor sourceCursor = sourceBlock.cursor();
            Slice sourceSlice = ((UncompressedBlock)sourceBlock).getSlice();
            this.strategy.setLookupSlice(sourceSlice);
            for (int position = 0; position < sourceBlock.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)sourceCursor.advanceNextPosition());
                this.containsNull |= sourceCursor.isNull();
                long sourceAddress = SyntheticAddress.encodeSyntheticAddress(-1, sourceCursor.getRawOffset());
                if (this.addressValueSet.contains(sourceAddress)) continue;
                int length = this.tupleInfo.size(sourceSlice, sourceCursor.getRawOffset());
                if (this.blockBuilder.writableBytes() < length) {
                    Slice slice = Slices.allocate((int)Math.max((int)BlockBuilder.DEFAULT_MAX_BLOCK_SIZE.toBytes(), length));
                    this.strategy.addSlice(slice);
                    this.blockBuilder = new BlockBuilder(this.tupleInfo, slice.length(), slice.getOutput());
                    ++this.currentBlockId;
                }
                int blockRawOffset = this.blockBuilder.size();
                this.blockBuilder.appendTuple(sourceSlice, sourceCursor.getRawOffset(), length);
                this.addressValueSet.add(SyntheticAddress.encodeSyntheticAddress(this.currentBlockId, blockRawOffset));
            }
        }

        public long getEstimatedSize() {
            return this.addressValueSet.getEstimatedSize().toBytes() + this.strategy.getEstimatedSize().toBytes();
        }

        public ChannelSet build() {
            return new ChannelSet(this.strategy, this.addressValueSet, this.containsNull);
        }
    }

    private static class AddressValueSet
    extends LongOpenCustomHashSet {
        private AddressValueSet(int expected, LongHash.Strategy strategy) {
            super(expected, strategy);
        }

        private AddressValueSet(AddressValueSet addressValueSet, LongHash.Strategy strategy) {
            super((LongCollection)addressValueSet, strategy);
        }

        public DataSize getEstimatedSize() {
            return new DataSize((double)(SizeOf.sizeOf((long[])this.key) + SizeOf.sizeOf((boolean[])this.used)), DataSize.Unit.BYTE);
        }
    }
}

