/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import io.airlift.configuration.Config;
import io.airlift.units.DataSize;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class ExchangeClientConfig {
    private DataSize exchangeMaxBufferSize = new DataSize(32.0, DataSize.Unit.MEGABYTE);
    private int exchangeConcurrentRequestMultiplier = 3;

    @NotNull
    public DataSize getExchangeMaxBufferSize() {
        return this.exchangeMaxBufferSize;
    }

    @Config(value="exchange.max-buffer-size")
    public ExchangeClientConfig setExchangeMaxBufferSize(DataSize exchangeMaxBufferSize) {
        this.exchangeMaxBufferSize = exchangeMaxBufferSize;
        return this;
    }

    @Min(value=1L)
    public int getExchangeConcurrentRequestMultiplier() {
        return this.exchangeConcurrentRequestMultiplier;
    }

    @Config(value="exchange.concurrent-request-multiplier")
    public ExchangeClientConfig setExchangeConcurrentRequestMultiplier(int exchangeConcurrentRequestMultiplier) {
        this.exchangeConcurrentRequestMultiplier = exchangeConcurrentRequestMultiplier;
        return this;
    }
}

