/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.AbstractFilterAndProjectOperator;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.FilterFunction;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.ProjectionFunction;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.tuple.TupleReadable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class FilterAndProjectOperator
extends AbstractFilterAndProjectOperator {
    private final FilterFunction filterFunction;
    private final List<ProjectionFunction> projections;

    public FilterAndProjectOperator(OperatorContext operatorContext, FilterFunction filterFunction, Iterable<? extends ProjectionFunction> projections) {
        super(operatorContext, FilterAndProjectOperator.toTupleInfos((Iterable)Preconditions.checkNotNull(projections, (Object)"projections is null")));
        this.filterFunction = (FilterFunction)Preconditions.checkNotNull((Object)filterFunction, (Object)"filterFunction is null");
        this.projections = ImmutableList.copyOf(projections);
    }

    @Override
    protected void filterAndProjectRowOriented(Page page, PageBuilder pageBuilder) {
        int rows = page.getPositionCount();
        TupleReadable[] cursors = new BlockCursor[page.getChannelCount()];
        for (int i = 0; i < page.getChannelCount(); ++i) {
            cursors[i] = page.getBlock(i).cursor();
        }
        for (int position = 0; position < rows; ++position) {
            for (BlockCursor blockCursor : cursors) {
                Preconditions.checkState((boolean)blockCursor.advanceNextPosition());
            }
            if (!this.filterFunction.filter(cursors)) continue;
            pageBuilder.declarePosition();
            for (int i = 0; i < this.projections.size(); ++i) {
                this.projections.get(i).project(cursors, pageBuilder.getBlockBuilder(i));
            }
        }
        for (BlockCursor blockCursor : cursors) {
            Preconditions.checkState((!blockCursor.advanceNextPosition() ? 1 : 0) != 0);
        }
    }

    private static List<TupleInfo> toTupleInfos(Iterable<? extends ProjectionFunction> projections) {
        ImmutableList.Builder tupleInfos = ImmutableList.builder();
        for (ProjectionFunction projectionFunction : projections) {
            tupleInfos.add((Object)projectionFunction.getTupleInfo());
        }
        return tupleInfos.build();
    }

    public static class FilterAndProjectOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final FilterFunction filterFunction;
        private final List<ProjectionFunction> projections;
        private final List<TupleInfo> tupleInfos;
        private boolean closed;

        public FilterAndProjectOperatorFactory(int operatorId, FilterFunction filterFunction, Iterable<? extends ProjectionFunction> projections) {
            this.operatorId = operatorId;
            this.filterFunction = (FilterFunction)Preconditions.checkNotNull((Object)filterFunction, (Object)"filterFunction is null");
            this.projections = ImmutableList.copyOf(projections);
            this.tupleInfos = FilterAndProjectOperator.toTupleInfos((Iterable)Preconditions.checkNotNull(projections, (Object)"projections is null"));
        }

        @Override
        public List<TupleInfo> getTupleInfos() {
            return this.tupleInfos;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, FilterAndProjectOperator.class.getSimpleName());
            return new FilterAndProjectOperator(operatorContext, this.filterFunction, this.projections);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

