/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.block.uncompressed.UncompressedBlock;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.Long2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.longs.LongHash;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;

public class GroupByHash {
    private static final long CURRENT_ROW_ADDRESS = -1L;
    private final List<TupleInfo.Type> types;
    private final int[] channels;
    private GroupByPageBuilder activePage;
    private final List<GroupByPageBuilder> allPages;
    private long completedPagesMemorySize;
    private final PageBuilderHashStrategy hashStrategy;
    private final PagePositionToGroupId pagePositionToGroupId;
    private int nextGroupId;

    public GroupByHash(List<TupleInfo.Type> types, int[] channels, int expectedSize) {
        this.types = (List)Preconditions.checkNotNull(types, (Object)"types is null");
        this.channels = (int[])((int[])Preconditions.checkNotNull((Object)channels, (Object)"channels is null")).clone();
        Preconditions.checkArgument((types.size() == channels.length ? 1 : 0) != 0, (Object)"types and channels have different sizes");
        this.allPages = ObjectArrayList.wrap((Object[])new GroupByPageBuilder[1024], (int)0);
        this.activePage = new GroupByPageBuilder(types);
        this.allPages.add(this.activePage);
        this.hashStrategy = new PageBuilderHashStrategy();
        this.pagePositionToGroupId = new PagePositionToGroupId(expectedSize, this.hashStrategy);
        this.pagePositionToGroupId.defaultReturnValue(-1);
    }

    public long getEstimatedSize() {
        return this.completedPagesMemorySize + this.activePage.getMemorySize() + this.pagePositionToGroupId.getEstimatedSize();
    }

    public List<TupleInfo.Type> getTypes() {
        return this.types;
    }

    public GroupByIdBlock getGroupIds(Page page) {
        int positionCount = page.getPositionCount();
        int groupIdBlockSize = TupleInfo.SINGLE_LONG.getFixedSize() * positionCount;
        BlockBuilder blockBuilder = new BlockBuilder(TupleInfo.SINGLE_LONG, groupIdBlockSize, Slices.allocate((int)groupIdBlockSize).getOutput());
        BlockCursor[] cursors = new BlockCursor[this.channels.length];
        for (int i = 0; i < this.channels.length; ++i) {
            cursors[i] = page.getBlock(this.channels[i]).cursor();
        }
        this.hashStrategy.setCurrentRow(cursors);
        for (int position = 0; position < positionCount; ++position) {
            for (BlockCursor cursor : cursors) {
                Preconditions.checkState((boolean)cursor.advanceNextPosition());
            }
            int groupId = this.pagePositionToGroupId.get(-1L);
            if (groupId < 0) {
                groupId = this.addNewGroup(cursors);
            }
            blockBuilder.append(groupId);
        }
        UncompressedBlock block = blockBuilder.build();
        return new GroupByIdBlock(this.nextGroupId, block);
    }

    private int addNewGroup(BlockCursor ... row) {
        int pageIndex = this.allPages.size() - 1;
        if (!this.activePage.append(row)) {
            this.completedPagesMemorySize += this.activePage.getMemorySize();
            this.activePage = new GroupByPageBuilder(this.types);
            this.allPages.add(this.activePage);
            ++pageIndex;
            Preconditions.checkState((boolean)this.activePage.append(row), (Object)"Could not add row to empty page builder");
        }
        int groupId = this.nextGroupId++;
        long address = SyntheticAddress.encodeSyntheticAddress(pageIndex, this.activePage.getPositionCount() - 1);
        this.pagePositionToGroupId.put(address, groupId);
        return groupId;
    }

    public Long2IntOpenCustomHashMap getPagePositionToGroupId() {
        return this.pagePositionToGroupId;
    }

    public void appendValuesTo(long pagePosition, BlockBuilder[] builders) {
        GroupByPageBuilder page = this.allPages.get(SyntheticAddress.decodeSliceIndex(pagePosition));
        page.appendValuesTo(SyntheticAddress.decodePosition(pagePosition), builders);
    }

    private static int addToHashCode(int result, int hashCode) {
        result = 31 * result + hashCode;
        return result;
    }

    private static int valueHashCode(TupleInfo.Type type, Slice slice, int offset) {
        boolean isNull;
        boolean bl = isNull = slice.getByte(offset) != 0;
        if (isNull) {
            return 0;
        }
        if (type == TupleInfo.Type.FIXED_INT_64) {
            return Longs.hashCode((long)slice.getLong(offset + 1));
        }
        if (type == TupleInfo.Type.DOUBLE) {
            long longValue = Double.doubleToLongBits(slice.getDouble(offset + 1));
            return Longs.hashCode((long)longValue);
        }
        if (type == TupleInfo.Type.BOOLEAN) {
            return slice.getByte(offset + 1) != 0 ? 1 : 0;
        }
        if (type == TupleInfo.Type.VARIABLE_BINARY) {
            int sliceLength = GroupByHash.getVariableBinaryLength(slice, offset);
            return slice.hashCode(offset + 1 + 4, sliceLength);
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }

    private static int getVariableBinaryLength(Slice slice, int offset) {
        return slice.getInt(offset + 1) - 4 - 1;
    }

    private static boolean valueEquals(TupleInfo.Type type, Slice leftSlice, int leftOffset, Slice rightSlice, int rightOffset) {
        boolean rightIsNull;
        boolean leftIsNull = leftSlice.getByte(leftOffset) != 0;
        boolean bl = rightIsNull = rightSlice.getByte(rightOffset) != 0;
        if (leftIsNull != rightIsNull) {
            return false;
        }
        if (leftIsNull) {
            return true;
        }
        if (type == TupleInfo.Type.FIXED_INT_64 || type == TupleInfo.Type.DOUBLE) {
            long rightValue;
            long leftValue = leftSlice.getLong(leftOffset + 1);
            return leftValue == (rightValue = rightSlice.getLong(rightOffset + 1));
        }
        if (type == TupleInfo.Type.BOOLEAN) {
            boolean leftValue = leftSlice.getByte(leftOffset + 1) != 0;
            boolean rightValue = rightSlice.getByte(rightOffset + 1) != 0;
            return leftValue == rightValue;
        }
        if (type == TupleInfo.Type.VARIABLE_BINARY) {
            int leftLength = GroupByHash.getVariableBinaryLength(leftSlice, leftOffset);
            int rightLength = GroupByHash.getVariableBinaryLength(rightSlice, rightOffset);
            return leftSlice.equals(leftOffset + 1 + 4, leftLength, rightSlice, rightOffset + 1 + 4, rightLength);
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }

    private static class PagePositionToGroupId
    extends Long2IntOpenCustomHashMap {
        private PagePositionToGroupId(int expected, LongHash.Strategy strategy) {
            super(expected, strategy);
            this.defaultReturnValue(-1);
        }

        public long getEstimatedSize() {
            return SizeOf.sizeOf((long[])this.key) + SizeOf.sizeOf((int[])this.value) + SizeOf.sizeOf((boolean[])this.used);
        }
    }

    private static class ChannelBuilder {
        public static final DataSize DEFAULT_MAX_BLOCK_SIZE = new DataSize(64.0, DataSize.Unit.KILOBYTE);
        private final TupleInfo.Type type;
        private final SliceOutput sliceOutput;
        private final Slice slice;
        private final IntArrayList positionOffsets;

        public ChannelBuilder(TupleInfo.Type type) {
            Preconditions.checkNotNull((Object)type, (Object)"type is null");
            this.type = type;
            this.slice = Slices.allocate((int)Ints.checkedCast((long)DEFAULT_MAX_BLOCK_SIZE.toBytes()));
            this.sliceOutput = this.slice.getOutput();
            this.positionOffsets = new IntArrayList(1024);
        }

        public long getMemorySize() {
            return (long)this.slice.length() + SizeOf.sizeOf((int[])this.positionOffsets.elements());
        }

        public boolean equals(int position, ChannelBuilder rightBuilder, int rightPosition) {
            Preconditions.checkArgument((position >= 0 && position < this.positionOffsets.size() ? 1 : 0) != 0);
            Preconditions.checkArgument((rightPosition >= 0 && rightPosition < rightBuilder.positionOffsets.size() ? 1 : 0) != 0);
            Slice leftSlice = this.slice;
            int leftOffset = this.positionOffsets.getInt(position);
            Slice rightSlice = rightBuilder.slice;
            int rightOffset = rightBuilder.positionOffsets.getInt(rightPosition);
            return GroupByHash.valueEquals(this.type, leftSlice, leftOffset, rightSlice, rightOffset);
        }

        public boolean equals(int position, BlockCursor cursor) {
            Preconditions.checkArgument((position >= 0 && position < this.positionOffsets.size() ? 1 : 0) != 0);
            int offset = this.positionOffsets.getInt(position);
            Slice rightSlice = cursor.getRawSlice();
            int rightOffset = cursor.getRawOffset();
            return GroupByHash.valueEquals(this.type, this.slice, offset, rightSlice, rightOffset);
        }

        public void appendTo(int position, BlockBuilder builder) {
            Preconditions.checkArgument((position >= 0 && position < this.positionOffsets.size() ? 1 : 0) != 0);
            int offset = this.positionOffsets.getInt(position);
            if (this.slice.getByte(offset) != 0) {
                builder.appendNull();
            } else if (this.type == TupleInfo.Type.FIXED_INT_64) {
                builder.append(this.slice.getLong(offset + 1));
            } else if (this.type == TupleInfo.Type.DOUBLE) {
                builder.append(this.slice.getDouble(offset + 1));
            } else if (this.type == TupleInfo.Type.BOOLEAN) {
                builder.append(this.slice.getByte(offset + 1) != 0);
            } else if (this.type == TupleInfo.Type.VARIABLE_BINARY) {
                int sliceLength = GroupByHash.getVariableBinaryLength(this.slice, offset);
                builder.append(this.slice.slice(offset + 1 + 4, sliceLength));
            } else {
                throw new IllegalArgumentException("Unsupported type " + this.type);
            }
        }

        public int hashCode(int position) {
            Preconditions.checkArgument((position >= 0 && position < this.positionOffsets.size() ? 1 : 0) != 0);
            return GroupByHash.valueHashCode(this.type, this.slice, this.positionOffsets.getInt(position));
        }

        public boolean append(BlockCursor cursor) {
            int writableBytes = this.sliceOutput.writableBytes() - 1;
            boolean isNull = cursor.isNull();
            if (this.type == TupleInfo.Type.FIXED_INT_64) {
                if (writableBytes < 8) {
                    return false;
                }
                this.positionOffsets.add(this.sliceOutput.size());
                this.sliceOutput.writeByte(isNull ? 1 : 0);
                this.sliceOutput.appendLong(isNull ? 0L : cursor.getLong());
            } else if (this.type == TupleInfo.Type.DOUBLE) {
                if (writableBytes < 8) {
                    return false;
                }
                this.positionOffsets.add(this.sliceOutput.size());
                this.sliceOutput.writeByte(isNull ? 1 : 0);
                this.sliceOutput.appendDouble(isNull ? 0.0 : cursor.getDouble());
            } else if (this.type == TupleInfo.Type.BOOLEAN) {
                if (writableBytes < 1) {
                    return false;
                }
                this.positionOffsets.add(this.sliceOutput.size());
                this.sliceOutput.writeByte(isNull ? 1 : 0);
                this.sliceOutput.writeByte(!isNull && cursor.getBoolean() ? 1 : 0);
            } else if (this.type == TupleInfo.Type.VARIABLE_BINARY) {
                int sliceLength;
                int n = sliceLength = isNull ? 0 : GroupByHash.getVariableBinaryLength(cursor.getRawSlice(), cursor.getRawOffset());
                if (writableBytes < 4 + sliceLength) {
                    return false;
                }
                int startingOffset = this.sliceOutput.size();
                this.positionOffsets.add(startingOffset);
                this.sliceOutput.writeByte(isNull ? 1 : 0);
                this.sliceOutput.appendInt(sliceLength + 1 + 4);
                if (!isNull) {
                    this.sliceOutput.writeBytes(cursor.getRawSlice(), cursor.getRawOffset() + 1 + 4, sliceLength);
                }
            } else {
                throw new IllegalArgumentException("Unsupported type " + this.type);
            }
            return true;
        }

        public UncompressedBlock build() {
            Preconditions.checkState((!this.positionOffsets.isEmpty() ? 1 : 0) != 0, (Object)"Cannot build an empty block");
            return new UncompressedBlock(this.positionOffsets.size(), new TupleInfo(this.type), this.sliceOutput.slice());
        }
    }

    private static class GroupByPageBuilder {
        private final List<ChannelBuilder> channels;
        private int positionCount;
        private boolean full;

        public GroupByPageBuilder(List<TupleInfo.Type> types) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (TupleInfo.Type type : types) {
                builder.add((Object)new ChannelBuilder(type));
            }
            this.channels = builder.build();
        }

        public int getPositionCount() {
            return this.positionCount;
        }

        public long getMemorySize() {
            long memorySize = 0L;
            for (ChannelBuilder channel : this.channels) {
                memorySize += channel.getMemorySize();
            }
            return memorySize;
        }

        private boolean append(BlockCursor ... row) {
            if (this.full) {
                return false;
            }
            for (int channel = 0; channel < row.length; ++channel) {
                if (this.channels.get(channel).append(row[channel])) continue;
                this.full = true;
                return false;
            }
            ++this.positionCount;
            return true;
        }

        public void appendValuesTo(int position, BlockBuilder[] builders) {
            for (int i = 0; i < this.channels.size(); ++i) {
                ChannelBuilder channel = this.channels.get(i);
                channel.appendTo(position, builders[i]);
            }
        }

        public int hashCode(int position) {
            int result = 0;
            for (ChannelBuilder channel : this.channels) {
                result = GroupByHash.addToHashCode(result, channel.hashCode(position));
            }
            return result;
        }

        public boolean equals(int thisPosition, GroupByPageBuilder that, int thatPosition) {
            for (int i = 0; i < this.channels.size(); ++i) {
                ChannelBuilder thatBlock;
                ChannelBuilder thisBlock = this.channels.get(i);
                if (thisBlock.equals(thisPosition, thatBlock = that.channels.get(i), thatPosition)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(int position, BlockCursor ... row) {
            for (int i = 0; i < this.channels.size(); ++i) {
                ChannelBuilder thisBlock = this.channels.get(i);
                if (thisBlock.equals(position, row[i])) continue;
                return false;
            }
            return true;
        }
    }

    private class PageBuilderHashStrategy
    implements LongHash.Strategy {
        private BlockCursor[] currentRow;

        private PageBuilderHashStrategy() {
        }

        public void setCurrentRow(BlockCursor[] currentRow) {
            this.currentRow = currentRow;
        }

        public int hashCode(long sliceAddress) {
            if (sliceAddress == -1L) {
                return this.hashCurrentRow();
            }
            return this.hashPosition(sliceAddress);
        }

        private int hashPosition(long sliceAddress) {
            int sliceIndex = SyntheticAddress.decodeSliceIndex(sliceAddress);
            int position = SyntheticAddress.decodePosition(sliceAddress);
            return ((GroupByPageBuilder)GroupByHash.this.allPages.get(sliceIndex)).hashCode(position);
        }

        private int hashCurrentRow() {
            int result = 0;
            for (int channel = 0; channel < GroupByHash.this.types.size(); ++channel) {
                TupleInfo.Type type = (TupleInfo.Type)GroupByHash.this.types.get(channel);
                BlockCursor cursor = this.currentRow[channel];
                result = GroupByHash.addToHashCode(result, GroupByHash.valueHashCode(type, cursor.getRawSlice(), cursor.getRawOffset()));
            }
            return result;
        }

        public boolean equals(long leftSliceAddress, long rightSliceAddress) {
            if (leftSliceAddress == -1L && rightSliceAddress == -1L) {
                return true;
            }
            if (leftSliceAddress == -1L) {
                return this.positionEqualsCurrentRow(SyntheticAddress.decodeSliceIndex(rightSliceAddress), SyntheticAddress.decodePosition(rightSliceAddress));
            }
            if (rightSliceAddress == -1L) {
                return this.positionEqualsCurrentRow(SyntheticAddress.decodeSliceIndex(leftSliceAddress), SyntheticAddress.decodePosition(leftSliceAddress));
            }
            return this.positionEqualsPosition(SyntheticAddress.decodeSliceIndex(leftSliceAddress), SyntheticAddress.decodePosition(leftSliceAddress), SyntheticAddress.decodeSliceIndex(rightSliceAddress), SyntheticAddress.decodePosition(rightSliceAddress));
        }

        private boolean positionEqualsCurrentRow(int sliceIndex, int position) {
            return ((GroupByPageBuilder)GroupByHash.this.allPages.get(sliceIndex)).equals(position, this.currentRow);
        }

        private boolean positionEqualsPosition(int leftSliceIndex, int leftPosition, int rightSliceIndex, int rightPosition) {
            return ((GroupByPageBuilder)GroupByHash.this.allPages.get(leftSliceIndex)).equals(leftPosition, (GroupByPageBuilder)GroupByHash.this.allPages.get(rightSliceIndex), rightPosition);
        }
    }
}

