/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.uncompressed.UncompressedBlock;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;

public class GroupByIdBlock
extends UncompressedBlock {
    private static final int ENTRY_SIZE = TupleInfo.SINGLE_LONG.getFixedSize();
    private final long groupCount;
    private final Slice slice;

    public GroupByIdBlock(long groupCount, UncompressedBlock block) {
        super(block);
        Preconditions.checkArgument((boolean)block.getTupleInfo().equals(TupleInfo.SINGLE_LONG), (Object)"Block must be a single long block");
        this.groupCount = groupCount;
        this.slice = block.getSlice();
    }

    public long getGroupCount() {
        return this.groupCount;
    }

    public long getGroupId(int position) {
        int entryOffset = position * ENTRY_SIZE;
        Preconditions.checkState((position >= 0 && entryOffset + ENTRY_SIZE <= this.slice.length() ? 1 : 0) != 0, (Object)"position is not valid");
        return this.slice.getLong(entryOffset + 1);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("groupCount", this.groupCount).add("positionCount", this.getPositionCount()).toString();
    }
}

