/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.JoinHash;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class HashBuilderOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final HashSupplier hashSupplier;
    private final List<Integer> hashChannels;
    private final PagesIndex pagesIndex;
    private boolean finished;

    public HashBuilderOperator(OperatorContext operatorContext, HashSupplier hashSupplier, List<Integer> hashChannels, int expectedPositions) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.hashSupplier = (HashSupplier)Preconditions.checkNotNull((Object)hashSupplier, (Object)"hashSupplier is null");
        Preconditions.checkArgument((!hashChannels.isEmpty() ? 1 : 0) != 0, (Object)"hashChannels is empty");
        this.hashChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(hashChannels, (Object)"hashChannels is null")));
        this.pagesIndex = new PagesIndex(hashSupplier.getTupleInfos(), expectedPositions, operatorContext);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<TupleInfo> getTupleInfos() {
        return this.hashSupplier.getTupleInfos();
    }

    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        JoinHash joinHash = new JoinHash(this.pagesIndex, this.hashChannels, this.operatorContext);
        this.hashSupplier.setHash(joinHash);
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return !this.finished;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0, (Object)"Operator is already finished");
        this.pagesIndex.addPage(page);
        this.operatorContext.recordGeneratedOutput(page.getDataSize(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    public static class HashBuilderOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final HashSupplier hashSupplier;
        private final List<Integer> hashChannels;
        private final int expectedPositions;
        private boolean closed;

        public HashBuilderOperatorFactory(int operatorId, List<TupleInfo> tupleInfos, List<Integer> hashChannels, int expectedPositions) {
            this.operatorId = operatorId;
            this.hashSupplier = new HashSupplier((List)Preconditions.checkNotNull(tupleInfos, (Object)"tupleInfos is null"));
            Preconditions.checkArgument((!hashChannels.isEmpty() ? 1 : 0) != 0, (Object)"hashChannels is empty");
            this.hashChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(hashChannels, (Object)"hashChannels is null")));
            this.expectedPositions = (Integer)Preconditions.checkNotNull((Object)expectedPositions, (Object)"expectedPositions is null");
        }

        public HashSupplier getHashSupplier() {
            return this.hashSupplier;
        }

        @Override
        public List<TupleInfo> getTupleInfos() {
            return this.hashSupplier.tupleInfos;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, HashBuilderOperator.class.getSimpleName());
            return new HashBuilderOperator(operatorContext, this.hashSupplier, this.hashChannels, this.expectedPositions);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }

    public static class HashSupplier {
        private final List<TupleInfo> tupleInfos;
        private final SettableFuture<JoinHash> hashFuture = SettableFuture.create();

        public HashSupplier(List<TupleInfo> tupleInfos) {
            this.tupleInfos = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(tupleInfos, (Object)"tupleInfos is null")));
        }

        public List<TupleInfo> getTupleInfos() {
            return this.tupleInfos;
        }

        public ListenableFuture<JoinHash> getSourceHash() {
            return Futures.transform(this.hashFuture, (Function)new Function<JoinHash, JoinHash>(){

                public JoinHash apply(JoinHash joinHash) {
                    return new JoinHash(joinHash);
                }
            });
        }

        void setHash(JoinHash joinHash) {
            boolean wasSet = this.hashFuture.set((Object)joinHash);
            Preconditions.checkState((boolean)wasSet, (Object)"Hash already set");
        }
    }
}

