/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.HashBuilderOperator;
import com.facebook.presto.operator.JoinHash;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.util.MoreFutures;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;

public class HashJoinOperator
implements Operator {
    private final ListenableFuture<JoinHash> hashFuture;
    private final OperatorContext operatorContext;
    private final int[] probeJoinChannels;
    private final boolean enableOuterJoin;
    private final List<TupleInfo> tupleInfos;
    private final BlockCursor[] cursors;
    private final PageBuilder pageBuilder;
    private JoinHash hash;
    private boolean finishing;
    private int joinPosition = -1;

    public static HashJoinOperatorFactory innerJoin(int operatorId, HashBuilderOperator.HashSupplier hashSupplier, List<TupleInfo> probeTupleInfos, List<Integer> probeJoinChannel) {
        return new HashJoinOperatorFactory(operatorId, hashSupplier, probeTupleInfos, probeJoinChannel, false);
    }

    public static HashJoinOperatorFactory outerJoin(int operatorId, HashBuilderOperator.HashSupplier hashSupplier, List<TupleInfo> probeTupleInfos, List<Integer> probeJoinChannel) {
        return new HashJoinOperatorFactory(operatorId, hashSupplier, probeTupleInfos, probeJoinChannel, true);
    }

    public HashJoinOperator(OperatorContext operatorContext, HashBuilderOperator.HashSupplier hashSupplier, List<TupleInfo> probeTupleInfos, List<Integer> probeJoinChannels, boolean enableOuterJoin) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        Preconditions.checkNotNull((Object)hashSupplier, (Object)"hashSupplier is null");
        Preconditions.checkNotNull(probeTupleInfos, (Object)"probeTupleInfos is null");
        this.hashFuture = hashSupplier.getSourceHash();
        this.probeJoinChannels = Ints.toArray(probeJoinChannels);
        this.enableOuterJoin = enableOuterJoin;
        this.tupleInfos = ImmutableList.builder().addAll(probeTupleInfos).addAll(hashSupplier.getTupleInfos()).build();
        this.pageBuilder = new PageBuilder(this.tupleInfos);
        this.cursors = new BlockCursor[probeTupleInfos.size()];
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<TupleInfo> getTupleInfos() {
        return this.tupleInfos;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        boolean finished;
        boolean bl = finished = this.finishing && this.cursors[0] == null && this.pageBuilder.isEmpty();
        if (finished) {
            this.hash = null;
            for (int i = 0; i < this.cursors.length; ++i) {
                this.cursors[i] = null;
            }
            this.pageBuilder.reset();
        }
        return finished;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.hashFuture;
    }

    @Override
    public boolean needsInput() {
        if (this.finishing) {
            return false;
        }
        if (this.hash == null) {
            this.hash = MoreFutures.tryGetUnchecked(this.hashFuture);
        }
        return this.hash != null && this.cursors[0] == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is finishing");
        Preconditions.checkState((this.hash != null ? 1 : 0) != 0, (Object)"Hash has not been built yet");
        Preconditions.checkState((this.cursors[0] == null ? 1 : 0) != 0, (Object)"Current page has not been completely processed yet");
        for (int i = 0; i < page.getChannelCount(); ++i) {
            this.cursors[i] = page.getBlock(i).cursor();
        }
        this.hash.setProbeCursors(this.cursors, this.probeJoinChannels);
        this.joinPosition = -1;
    }

    @Override
    public Page getOutput() {
        if (this.cursors[0] != null) {
            while (this.joinCurrentPosition() && this.advanceProbePosition() && this.outerJoinCurrentPosition()) {
            }
        }
        if (this.pageBuilder.isFull() || this.finishing && !this.pageBuilder.isEmpty() && this.cursors[0] == null) {
            Page page = this.pageBuilder.build();
            this.pageBuilder.reset();
            return page;
        }
        return null;
    }

    private boolean joinCurrentPosition() {
        while (this.joinPosition >= 0) {
            for (int i = 0; i < this.cursors.length; ++i) {
                this.cursors[i].appendTupleTo(this.pageBuilder.getBlockBuilder(i));
            }
            this.hash.appendTupleTo(this.joinPosition, this.pageBuilder, this.cursors.length);
            this.joinPosition = this.hash.getNextJoinPosition(this.joinPosition);
            if (!this.pageBuilder.isFull()) continue;
            return false;
        }
        return true;
    }

    private boolean advanceProbePosition() {
        if (!this.advanceNextCursorPosition()) {
            return false;
        }
        this.joinPosition = this.currentRowJoinPositionContainsNull() ? -1 : this.hash.getJoinPosition();
        return true;
    }

    private boolean outerJoinCurrentPosition() {
        if (this.enableOuterJoin && this.joinPosition < 0) {
            int outputIndex = 0;
            for (BlockCursor cursor : this.cursors) {
                cursor.appendTupleTo(this.pageBuilder.getBlockBuilder(outputIndex));
                ++outputIndex;
            }
            for (int buildChannel = 0; buildChannel < this.hash.getChannelCount(); ++buildChannel) {
                this.pageBuilder.getBlockBuilder(outputIndex).appendNull();
                ++outputIndex;
            }
            if (this.pageBuilder.isFull()) {
                return false;
            }
        }
        return true;
    }

    public boolean advanceNextCursorPosition() {
        int i;
        boolean advanced = this.cursors[0].advanceNextPosition();
        for (i = 1; i < this.cursors.length; ++i) {
            Preconditions.checkState((advanced == this.cursors[i].advanceNextPosition() ? 1 : 0) != 0);
        }
        if (!advanced) {
            for (i = 0; i < this.cursors.length; ++i) {
                this.cursors[i] = null;
            }
        }
        return advanced;
    }

    private boolean currentRowJoinPositionContainsNull() {
        for (int probeJoinChannel : this.probeJoinChannels) {
            if (!this.cursors[probeJoinChannel].isNull()) continue;
            return true;
        }
        return false;
    }

    public static class HashJoinOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final HashBuilderOperator.HashSupplier hashSupplier;
        private final List<TupleInfo> probeTupleInfos;
        private final List<Integer> probeJoinChannels;
        private final boolean enableOuterJoin;
        private final List<TupleInfo> tupleInfos;
        private boolean closed;

        public HashJoinOperatorFactory(int operatorId, HashBuilderOperator.HashSupplier hashSupplier, List<TupleInfo> probeTupleInfos, List<Integer> probeJoinChannels, boolean enableOuterJoin) {
            this.operatorId = operatorId;
            this.hashSupplier = hashSupplier;
            this.probeTupleInfos = probeTupleInfos;
            this.probeJoinChannels = probeJoinChannels;
            this.enableOuterJoin = enableOuterJoin;
            this.tupleInfos = ImmutableList.builder().addAll(probeTupleInfos).addAll(hashSupplier.getTupleInfos()).build();
        }

        @Override
        public List<TupleInfo> getTupleInfos() {
            return this.tupleInfos;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, HashJoinOperator.class.getSimpleName());
            return new HashJoinOperator(operatorContext, this.hashSupplier, this.probeTupleInfos, this.probeJoinChannels, this.enableOuterJoin);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

