/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.tuple.TupleInfo;
import com.google.common.primitives.Longs;
import io.airlift.slice.Slice;

public final class HashStrategyUtils {
    private HashStrategyUtils() {
    }

    public static int addToHashCode(int result, int hashCode) {
        result = 31 * result + hashCode;
        return result;
    }

    private static int getVariableBinaryLength(Slice slice, int offset) {
        return slice.getInt(offset + 1);
    }

    public static boolean valueEquals(TupleInfo.Type type, Slice leftSlice, int leftOffset, Slice rightSlice, int rightOffset) {
        boolean rightIsNull;
        boolean leftIsNull = leftSlice.getByte(leftOffset) != 0;
        boolean bl = rightIsNull = rightSlice.getByte(rightOffset) != 0;
        if (leftIsNull != rightIsNull) {
            return false;
        }
        if (leftIsNull) {
            return true;
        }
        if (type == TupleInfo.Type.FIXED_INT_64 || type == TupleInfo.Type.DOUBLE) {
            long rightValue;
            long leftValue = leftSlice.getLong(leftOffset + 1);
            return leftValue == (rightValue = rightSlice.getLong(rightOffset + 1));
        }
        if (type == TupleInfo.Type.BOOLEAN) {
            boolean leftValue = leftSlice.getByte(leftOffset + 1) != 0;
            boolean rightValue = rightSlice.getByte(rightOffset + 1) != 0;
            return leftValue == rightValue;
        }
        if (type == TupleInfo.Type.VARIABLE_BINARY) {
            int leftLength = HashStrategyUtils.getVariableBinaryLength(leftSlice, leftOffset);
            int rightLength = HashStrategyUtils.getVariableBinaryLength(rightSlice, rightOffset);
            return leftSlice.equals(leftOffset, leftLength, rightSlice, rightOffset, rightLength);
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }

    public static int valueHashCode(TupleInfo.Type type, Slice slice, int offset) {
        boolean isNull;
        boolean bl = isNull = slice.getByte(offset) != 0;
        if (isNull) {
            return 0;
        }
        if (type == TupleInfo.Type.FIXED_INT_64) {
            return Longs.hashCode((long)slice.getLong(offset + 1));
        }
        if (type == TupleInfo.Type.DOUBLE) {
            long longValue = Double.doubleToLongBits(slice.getDouble(offset + 1));
            return Longs.hashCode((long)longValue);
        }
        if (type == TupleInfo.Type.BOOLEAN) {
            return slice.getByte(offset + 1) != 0 ? 1 : 0;
        }
        if (type == TupleInfo.Type.VARIABLE_BINARY) {
            int sliceLength = HashStrategyUtils.getVariableBinaryLength(slice, offset);
            return slice.hashCode(offset, sliceLength);
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }
}

