/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.PrestoMediaTypes;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBufferClientStatus;
import com.facebook.presto.serde.PagesSerde;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import io.airlift.http.client.AsyncHttpClient;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.ResponseHandlerUtils;
import io.airlift.http.client.StatusResponseHandler;
import io.airlift.log.Logger;
import io.airlift.slice.InputStreamSliceInput;
import io.airlift.slice.SliceInput;
import io.airlift.units.DataSize;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;

@ThreadSafe
public class HttpPageBufferClient
implements Closeable {
    private static final Logger log = Logger.get(HttpPageBufferClient.class);
    private final Executor executor;
    private final AsyncHttpClient httpClient;
    private final DataSize maxResponseSize;
    private final URI location;
    private final ClientCallback clientCallback;
    @GuardedBy(value="this")
    private boolean closed;
    @GuardedBy(value="this")
    private HttpClient.HttpResponseFuture<PagesResponse> future;
    @GuardedBy(value="this")
    private DateTime lastUpdate = DateTime.now();
    @GuardedBy(value="this")
    private long token;
    private final AtomicInteger pagesReceived = new AtomicInteger();
    private final AtomicInteger requestsScheduled = new AtomicInteger();
    private final AtomicInteger requestsCompleted = new AtomicInteger();

    public HttpPageBufferClient(AsyncHttpClient httpClient, DataSize maxResponseSize, URI location, ClientCallback clientCallback, Executor executor) {
        this.httpClient = (AsyncHttpClient)Preconditions.checkNotNull((Object)httpClient, (Object)"httpClient is null");
        this.maxResponseSize = (DataSize)Preconditions.checkNotNull((Object)maxResponseSize, (Object)"maxResponseSize is null");
        this.location = (URI)Preconditions.checkNotNull((Object)location, (Object)"location is null");
        this.clientCallback = (ClientCallback)Preconditions.checkNotNull((Object)clientCallback, (Object)"clientCallback is null");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
    }

    public synchronized PageBufferClientStatus getStatus() {
        String state = this.closed ? "closed" : (this.future != null ? "running" : "queued");
        String httpRequestState = "queued";
        if (this.future != null) {
            httpRequestState = this.future.getState();
        }
        return new PageBufferClientStatus(this.location, state, this.lastUpdate, this.pagesReceived.get(), this.requestsScheduled.get(), this.requestsCompleted.get(), httpRequestState);
    }

    public synchronized boolean isRunning() {
        return this.future != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HttpClient.HttpResponseFuture<PagesResponse> future;
        boolean shouldSendDelete;
        HttpPageBufferClient httpPageBufferClient = this;
        synchronized (httpPageBufferClient) {
            shouldSendDelete = !this.closed;
            this.closed = true;
            future = this.future;
            this.future = null;
            this.lastUpdate = DateTime.now();
        }
        if (future != null) {
            future.cancel(true);
        }
        if (shouldSendDelete) {
            this.httpClient.executeAsync(Request.Builder.prepareDelete().setUri(this.location).build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        }
    }

    public synchronized void scheduleRequest() {
        if (this.closed) {
            log.debug("scheduleRequest() called, but client has been closed");
            return;
        }
        if (this.future != null) {
            log.debug("scheduleRequest() called, but future is not null");
            return;
        }
        final URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.location).appendPath(String.valueOf(this.token)).build();
        this.future = this.httpClient.executeAsync(Request.Builder.prepareGet().setHeader("X-Presto-Max-Size", this.maxResponseSize.toString()).setUri(uri).build(), (ResponseHandler)new PageResponseHandler());
        Futures.addCallback(this.future, (FutureCallback)new FutureCallback<PagesResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(PagesResponse result) {
                Object pages;
                if (Thread.holdsLock(HttpPageBufferClient.this)) {
                    log.error("Can not handle callback while holding a lock on this");
                }
                HttpPageBufferClient.this.requestsCompleted.incrementAndGet();
                HttpPageBufferClient httpPageBufferClient = HttpPageBufferClient.this;
                synchronized (httpPageBufferClient) {
                    if (result.getToken() == HttpPageBufferClient.this.token) {
                        pages = result.getPages();
                        HttpPageBufferClient.this.token = result.getNextToken();
                    } else {
                        pages = ImmutableList.of();
                    }
                }
                Iterator i$ = pages.iterator();
                while (i$.hasNext()) {
                    Page page = (Page)i$.next();
                    HttpPageBufferClient.this.pagesReceived.incrementAndGet();
                    HttpPageBufferClient.this.clientCallback.addPage(HttpPageBufferClient.this, page);
                }
                if (result.isClientClosed()) {
                    httpPageBufferClient = HttpPageBufferClient.this;
                    synchronized (httpPageBufferClient) {
                        HttpPageBufferClient.this.closed = true;
                        HttpPageBufferClient.this.future = null;
                        HttpPageBufferClient.this.lastUpdate = DateTime.now();
                    }
                    HttpPageBufferClient.this.clientCallback.clientFinished(HttpPageBufferClient.this);
                } else {
                    httpPageBufferClient = HttpPageBufferClient.this;
                    synchronized (httpPageBufferClient) {
                        HttpPageBufferClient.this.future = null;
                        HttpPageBufferClient.this.lastUpdate = DateTime.now();
                    }
                    HttpPageBufferClient.this.clientCallback.requestComplete(HttpPageBufferClient.this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(Throwable t) {
                log.debug("Request to %s failed %s", new Object[]{uri, t});
                if (Thread.holdsLock(HttpPageBufferClient.this)) {
                    log.error("Can not handle callback while holding a lock on this");
                }
                HttpPageBufferClient.this.requestsCompleted.incrementAndGet();
                HttpPageBufferClient httpPageBufferClient = HttpPageBufferClient.this;
                synchronized (httpPageBufferClient) {
                    HttpPageBufferClient.this.future = null;
                    HttpPageBufferClient.this.lastUpdate = DateTime.now();
                }
                HttpPageBufferClient.this.clientCallback.requestComplete(HttpPageBufferClient.this);
            }
        }, (Executor)this.executor);
        this.lastUpdate = DateTime.now();
        this.requestsScheduled.incrementAndGet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpPageBufferClient that = (HttpPageBufferClient)o;
        return this.location.equals(that.location);
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String state;
        HttpPageBufferClient httpPageBufferClient = this;
        synchronized (httpPageBufferClient) {
            state = this.closed ? "CLOSED" : (this.future != null ? "RUNNING" : "QUEUED");
        }
        return Objects.toStringHelper((Object)this).add("location", (Object)this.location).addValue((Object)state).toString();
    }

    public static class PagesResponse {
        private final long token;
        private final long nextToken;
        private final List<Page> pages;
        private final boolean clientClosed;

        public static PagesResponse createPagesResponse(long token, long nextToken, Iterable<Page> pages) {
            return new PagesResponse(token, nextToken, pages, false);
        }

        public static PagesResponse createEmptyPagesResponse(long token, long nextToken) {
            return new PagesResponse(token, nextToken, (Iterable<Page>)ImmutableList.of(), false);
        }

        public static PagesResponse createClosedResponse(long token, long nextToken) {
            return new PagesResponse(token, nextToken, (Iterable<Page>)ImmutableList.of(), true);
        }

        public PagesResponse(long token, long nextToken, Iterable<Page> pages, boolean clientClosed) {
            this.token = token;
            this.nextToken = nextToken;
            this.pages = ImmutableList.copyOf(pages);
            this.clientClosed = clientClosed;
        }

        public long getToken() {
            return this.token;
        }

        public long getNextToken() {
            return this.nextToken;
        }

        public List<Page> getPages() {
            return this.pages;
        }

        public boolean isClientClosed() {
            return this.clientClosed;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("token", this.token).add("nextToken", this.nextToken).add("pages.size()", this.pages.size()).add("clientClosed", this.clientClosed).toString();
        }
    }

    public static class PageResponseHandler
    implements ResponseHandler<PagesResponse, RuntimeException> {
        public PagesResponse handleException(Request request, Exception exception) {
            throw ResponseHandlerUtils.propagate((Request)request, (Throwable)exception);
        }

        public PagesResponse handle(Request request, Response response) {
            String tokenHeader = response.getHeader("X-Presto-Page-Sequence-Id");
            if (tokenHeader == null) {
                throw new IllegalStateException("Expected X-Presto-Page-Sequence-Id header");
            }
            long token = Long.parseLong(tokenHeader);
            String nextTokenHeader = response.getHeader("X-Presto-Page-End-Sequence-Id");
            if (nextTokenHeader == null) {
                throw new IllegalStateException("Expected X-Presto-Page-End-Sequence-Id header");
            }
            long nextToken = Long.parseLong(nextTokenHeader);
            if (response.getStatusCode() == HttpStatus.GONE.code()) {
                return PagesResponse.createClosedResponse(token, nextToken);
            }
            if (response.getStatusCode() == HttpStatus.NO_CONTENT.code()) {
                return PagesResponse.createEmptyPagesResponse(token, nextToken);
            }
            if (response.getStatusCode() != HttpStatus.OK.code()) {
                log.debug("Expected response code to be 200, but was %s: request=%s, response=%s", new Object[]{response.getStatusCode(), request, response});
                return PagesResponse.createEmptyPagesResponse(token, nextToken);
            }
            String contentType = response.getHeader("Content-Type");
            if (contentType == null || !MediaType.parse((String)contentType).is(PrestoMediaTypes.PRESTO_PAGES_TYPE)) {
                log.debug("Expected %s response from server but got %s: uri=%s, response=%s", new Object[]{PrestoMediaTypes.PRESTO_PAGES_TYPE, contentType, request.getUri(), response});
                return PagesResponse.createEmptyPagesResponse(token, nextToken);
            }
            try {
                InputStreamSliceInput sliceInput = new InputStreamSliceInput(response.getInputStream());
                return PagesResponse.createPagesResponse(token, nextToken, (Iterable<Page>)ImmutableList.copyOf(PagesSerde.readPages((SliceInput)sliceInput)));
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public static interface ClientCallback {
        public void addPage(HttpPageBufferClient var1, Page var2);

        public void requestComplete(HttpPageBufferClient var1);

        public void clientFinished(HttpPageBufferClient var1);
    }
}

